/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.awt;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CleanResizeListener
extends ControlAdapter {
    private Rectangle oldRect = null;

    public void controlResized(ControlEvent e) {
        assert (e != null);
        assert (Display.getCurrent() != null);
        Composite composite = (Composite)e.widget;
        Rectangle newRect = composite.getClientArea();
        if (this.oldRect != null) {
            int heightDelta = newRect.height - this.oldRect.height;
            int widthDelta = newRect.width - this.oldRect.width;
            if (heightDelta > 0 || widthDelta > 0) {
                GC gc = new GC((Drawable)composite);
                try {
                    gc.fillRectangle(newRect.x, this.oldRect.height, newRect.width, heightDelta);
                    gc.fillRectangle(this.oldRect.width, newRect.y, widthDelta, newRect.height);
                }
                finally {
                    gc.dispose();
                }
            }
        }
        this.oldRect = newRect;
    }
}

