/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class SWTUtils {
    public static boolean asyncExec(Display display, Runnable runnable) {
        block3: {
            try {
                if (!display.isDisposed()) break block3;
                return false;
            }
            catch (SWTException e) {
                return false;
            }
        }
        display.asyncExec(runnable);
        return true;
    }

    public static boolean asyncExec(Widget widget, Runnable runnable) {
        block3: {
            try {
                if (!widget.isDisposed()) break block3;
                return false;
            }
            catch (SWTException e) {
                return false;
            }
        }
        widget.getDisplay().asyncExec(runnable);
        return true;
    }

    public static void invokeAndDispatchEvents(Display display, IThreadWorkQueue inThread, final Runnable invoke) throws InterruptedException {
        if (display.isDisposed()) {
            throw new IllegalArgumentException("display is disposed");
        }
        final Semaphore sem = new Semaphore(0);
        ThreadUtils.asyncExec((IThreadWorkQueue)inThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    invoke.run();
                }
                finally {
                    sem.release();
                }
            }
        });
        boolean done = false;
        while (!done) {
            done = sem.tryAcquire(10L, TimeUnit.MILLISECONDS);
            while (!done && display.readAndDispatch()) {
                done = sem.tryAcquire();
            }
        }
    }
}

