/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SWTAWTTest {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        SWTAWTTest.tryCTabFolder();
        SWTAWTTest.tryTabFolder();
        SWTAWTTest.trySideBySide();
        display.addFilter(26, new Listener(){

            public void handleEvent(Event event) {
                System.out.println("SWT.Activate: " + event.widget + " (" + System.identityHashCode(event.widget) + ")");
            }
        });
        while (!display.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
            System.out.print(".");
        }
    }

    private static void tryTabFolder() {
        TabItem item;
        Shell shell = new Shell();
        shell.setText("TabFolder");
        shell.setLayout((Layout)new FillLayout());
        TabFolder folder = new TabFolder((Composite)shell, 0);
        int i = 0;
        while (i < 2) {
            item = new TabItem(folder, 0);
            item.setText("#" + i);
            item.setControl(SWTAWTTest.openTable((Composite)folder));
            ++i;
        }
        folder.setSelection(0);
        folder = new TabFolder((Composite)shell, 0);
        i = 0;
        while (i < 2) {
            item = new TabItem(folder, 0);
            item.setText("#" + i);
            item.setControl(SWTAWTTest.openTable((Composite)folder));
            ++i;
        }
        folder.setSelection(0);
        shell.open();
    }

    private static void tryCTabFolder() {
        CTabItem item;
        Shell shell = new Shell();
        shell.setText("CTabFolder");
        shell.setLayout((Layout)new FillLayout());
        CTabFolder folder = new CTabFolder((Composite)shell, 0);
        int i = 0;
        while (i < 2) {
            item = new CTabItem(folder, 0);
            item.setText("#" + i);
            item.setControl(SWTAWTTest.openTable((Composite)folder));
            ++i;
        }
        folder.setSelection(0);
        folder = new CTabFolder((Composite)shell, 0);
        i = 0;
        while (i < 2) {
            item = new CTabItem(folder, 0);
            item.setText("#" + i);
            item.setControl(SWTAWTTest.openTable((Composite)folder));
            ++i;
        }
        folder.setSelection(0);
        shell.open();
    }

    private static void trySideBySide() {
        Shell shell = new Shell();
        shell.setText("Side by Side (FillLayout)");
        shell.setLayout((Layout)new FillLayout());
        SWTAWTTest.openTable((Composite)shell);
        SWTAWTTest.openTable((Composite)shell);
        shell.open();
    }

    private static Control openTable(Composite outer) {
        final Composite parent = new Composite(outer, 0x1000000);
        final Frame frame = SWT_AWT.new_Frame((Composite)parent);
        final Display display = outer.getDisplay();
        String ver = System.getProperty("java.version");
        if (ver.startsWith("1.7") || ver.startsWith("1.8")) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (display.getFocusControl() == parent) {
                                try {
                                    Method m = Shell.class.getDeclaredMethod("setActiveControl", Control.class);
                                    boolean accessible = m.isAccessible();
                                    if (!accessible) {
                                        m.setAccessible(true);
                                    }
                                    m.invoke((Object)parent.getShell(), parent);
                                    if (!accessible) {
                                        m.setAccessible(false);
                                    }
                                }
                                catch (SecurityException e) {
                                    e.printStackTrace();
                                }
                                catch (NoSuchMethodException e) {
                                    e.printStackTrace();
                                }
                                catch (IllegalArgumentException e) {
                                    e.printStackTrace();
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.add(SWTAWTTest.createTable());
            }
        });
        return parent;
    }

    private static JComponent createTable() {
        int nrows = 1000;
        int ncolumns = 10;
        Vector rows = new Vector();
        int i = 0;
        while (i < nrows) {
            Vector<String> row = new Vector<String>();
            int j = 0;
            while (j < ncolumns) {
                row.addElement("Item " + i + "-" + j);
                ++j;
            }
            rows.addElement(row);
            ++i;
        }
        Vector<String> columns = new Vector<String>();
        int i2 = 0;
        while (i2 < ncolumns) {
            columns.addElement("Column " + i2);
            ++i2;
        }
        JTable table = new JTable(rows, columns);
        table.setAutoResizeMode(0);
        table.createDefaultColumnsFromModel();
        JScrollPane scrollPane = new JScrollPane(table);
        return scrollPane;
    }
}

