/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class PathUtils {
    public static IPath getAbsolutePath(Bundle inBundle, String fullpath) {
        Path path = new Path(fullpath);
        URL u = FileLocator.find((Bundle)inBundle, (IPath)path, null);
        if (u != null) {
            try {
                u = FileLocator.resolve((URL)u);
                if ("file".equals(u.getProtocol())) {
                    Path p = new Path(new File(u.getFile()).getAbsolutePath());
                    return p;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getAbsolutePathString(Bundle inBundle, String fullpath) {
        IPath p = PathUtils.getAbsolutePath(inBundle, fullpath);
        return p != null ? p.toOSString() : null;
    }

    public static IPath getAbsolutePath(String inBundle, String fullpath) {
        Bundle b = Platform.getBundle((String)inBundle);
        if (b == null) {
            return null;
        }
        return PathUtils.getAbsolutePath(b, fullpath);
    }

    public static String getAbsolutePathString(String inBundle, String fullpath) {
        Bundle b = Platform.getBundle((String)inBundle);
        if (b == null) {
            return null;
        }
        return PathUtils.getAbsolutePathString(b, fullpath);
    }
}

