/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ISelectionUtils<T> {
    public static <T> List<T> convertSelection(ISelection sel) throws ClassCastException {
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        IStructuredSelection ss = (IStructuredSelection)sel;
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result.add(o);
            ++n2;
        }
        return result;
    }

    public static <T> Set<T> convertSetSelection(ISelection sel) throws ClassCastException {
        if (sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return Collections.emptySet();
        }
        HashSet<Object> result = new HashSet<Object>();
        IStructuredSelection ss = (IStructuredSelection)sel;
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result.add(o);
            ++n2;
        }
        return result;
    }

    public static <T> T convertSingleSelection(ISelection sel) {
        if (sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)sel;
        return (T)(ss.size() == 1 ? ss.getFirstElement() : null);
    }

    public static <T> List<T> filterSelection(ISelection sel, Class<T> assignableFrom) {
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        IStructuredSelection ss = (IStructuredSelection)sel;
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object t;
            Object o = objectArray[n2];
            if (o != null && assignableFrom.isAssignableFrom(o.getClass())) {
                result.add(o);
            } else if (o instanceof IAdaptable && (t = ((IAdaptable)o).getAdapter(assignableFrom)) != null) {
                result.add(t);
            }
            ++n2;
        }
        return result;
    }

    public static <T> Set<T> filterSetSelection(Object sel, Class<T> assignableFrom) {
        Collection c;
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            if (!ss.isEmpty()) {
                return ISelectionUtils.filterCollection(ss.toList(), assignableFrom, new HashSet());
            }
        } else if (sel instanceof Collection && !(c = (Collection)sel).isEmpty()) {
            return ISelectionUtils.filterCollection(c, assignableFrom, new HashSet());
        }
        return Collections.emptySet();
    }

    public static <T> T filterSingleSelection(Object sel, Class<T> assignableTo) {
        if (sel == null) {
            return null;
        }
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            if (ss.size() == 1) {
                return ISelectionUtils.tryAdapt(ss.getFirstElement(), assignableTo);
            }
        } else if (sel instanceof Collection) {
            Collection c = (Collection)sel;
            if (c.size() == 1) {
                return ISelectionUtils.tryAdapt(c.iterator().next(), assignableTo);
            }
        } else if (sel.getClass().isArray()) {
            Object[] os = (Object[])sel;
            T result = null;
            Object[] objectArray = os;
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                T r = ISelectionUtils.tryAdapt(o, assignableTo);
                if (r != null) {
                    if (result != null) {
                        return null;
                    }
                    result = r;
                }
                ++n2;
            }
            return result;
        }
        return null;
    }

    public static <T> T findFirstAdaptable(Object sel, Class<T> assignableTo) {
        Collection c;
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            if (!ss.isEmpty()) {
                return ISelectionUtils.findFirstAdaptable_(ss.toList(), assignableTo);
            }
        } else if (sel instanceof Collection && !(c = (Collection)sel).isEmpty()) {
            return ISelectionUtils.findFirstAdaptable_(c, assignableTo);
        }
        return null;
    }

    private static <T> T findFirstAdaptable_(Collection<?> objects, Class<T> assignableTo) {
        for (Object o : objects) {
            T t = ISelectionUtils.tryAdapt(o, assignableTo);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private static <T, C extends Collection<T>> C filterCollection(Collection<?> objects, Class<T> assignableTo, C result) {
        for (Object o : objects) {
            T t = ISelectionUtils.tryAdapt(o, assignableTo);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    private static <T> T tryAdapt(Object o, Class<T> assignableTo) {
        Object t;
        if (o != null && assignableTo.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        if (o instanceof IAdaptable && (t = ((IAdaptable)o).getAdapter(assignableTo)) != null) {
            return (T)t;
        }
        return null;
    }

    public static <T> T getSinglePossibleKey(Object object, IHintContext.Key key, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (object instanceof ISelection) {
            ISelection sel = (ISelection)object;
            if (sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
                return null;
            }
            IStructuredSelection ss = (IStructuredSelection)sel;
            if (ss.size() != 1) {
                return null;
            }
            return ISelectionUtils.getSinglePossibleKey(ss.getFirstElement(), key, clazz);
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            if (c.size() != 1) {
                return null;
            }
            return ISelectionUtils.getSinglePossibleKey(c.iterator().next(), key, clazz);
        }
        if (object instanceof IHintContext) {
            IHintContext context = (IHintContext)object;
            Object hint = context.getHint(key);
            if (hint == null) {
                Map hints = context.getHints();
                if (hints.size() != 1) {
                    return null;
                }
                hint = hints.values().iterator().next();
                T t = ISelectionUtils.getSinglePossibleKey(hint, key, clazz);
                return t;
            }
            if (clazz.isInstance(hint)) {
                return (T)hint;
            }
            if (hint instanceof IAdaptable) {
                Object adapter = ((IAdaptable)hint).getAdapter(clazz);
                if (adapter != null) {
                    return (T)adapter;
                }
            } else {
                return ISelectionUtils.getSinglePossibleKey(hint, key, clazz);
            }
        }
        if (object instanceof IAdaptable) {
            return ISelectionUtils.getSinglePossibleKey(((IAdaptable)object).getAdapter(IHintContext.class), key, clazz);
        }
        return null;
    }

    public static <T> List<T> getPossibleKeys(Object selection, IHintContext.Key key, Class<T> clazz) {
        if (selection == null) {
            return Collections.emptyList();
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.isEmpty()) {
                return Collections.emptyList();
            }
            return ISelectionUtils.extractPossibleKeys(ss.toList(), key, clazz);
        }
        if (selection instanceof Collection) {
            Collection c = (Collection)selection;
            return ISelectionUtils.extractPossibleKeys(c, key, clazz);
        }
        if (selection.getClass().isArray()) {
            Object[] c = (Object[])selection;
            return ISelectionUtils.extractPossibleKeys(c, key, clazz);
        }
        return ISelectionUtils.extractPossibleKeys(Collections.singleton(selection), key, clazz);
    }

    private static <T> List<T> extractPossibleKeys(Collection<?> objects, IHintContext.Key key, Class<T> clazz) {
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(objects.size());
        for (Object o : objects) {
            Object adapter;
            IHintContext context;
            Object object;
            if (!(o instanceof IHintContext) || (object = (context = (IHintContext)o).getHint(key)) == null) continue;
            if (clazz.isInstance(object)) {
                result.add(object);
                continue;
            }
            if (!(object instanceof IAdaptable) || (adapter = ((IAdaptable)object).getAdapter(clazz)) == null) continue;
            result.add(adapter);
        }
        return result;
    }

    private static <T> List<T> extractPossibleKeys(Object[] objects, IHintContext.Key key, Class<T> clazz) {
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(objects.length);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IHintContext context;
            Object object;
            Object o = objectArray[n2];
            if (o instanceof IHintContext && (object = (context = (IHintContext)o).getHint(key)) != null) {
                Object adapter;
                if (clazz.isInstance(object)) {
                    result.add(object);
                } else if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(clazz)) != null) {
                    result.add(adapter);
                }
            }
            ++n2;
        }
        return result;
    }

    public static ISelection createSelection(Object ... objects) {
        return new StructuredSelection(objects);
    }

    public static void main(String[] args) {
        Integer o1 = new Integer(9);
        HashMap o2 = new HashMap();
        Long o3 = new Long(1L);
        ISelection s1 = ISelectionUtils.createSelection(o1, o2, o3);
        List f1 = ISelectionUtils.convertSelection(s1);
        List<Number> f2 = ISelectionUtils.filterSelection(s1, Number.class);
        System.out.println(f1.toString());
        System.out.println(f2.toString());
        Assert.isTrue((f2.contains(o1) && f2.contains(o3) && !f2.contains(o2) ? 1 : 0) != 0);
        Assert.isTrue((f1.contains(o1) && f1.contains(o3) && !f1.contains(o2) ? 1 : 0) != 0);
    }
}

