/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core.widget;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.swt.InputSourceImpl;
import org.simantics.browsing.ui.swt.widgets.DragSourceListenerFactory;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.ModelBrowser;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.layer0.variable.VariableBean;
import org.simantics.db.management.ISessionContext;
import org.simantics.document.server.JSONObject;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.base.WidgetContainer;
import org.simantics.document.swt.core.bean.ColumnBean;
import org.simantics.document.swt.core.bean.ColumnsBean;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

public class Explorer
extends LeafWidgetManager<ModelBrowser> {
    @Override
    protected void doUpdateProperties(SWTDocument document, ModelBrowser control, JSONObject object) {
    }

    protected Column[] getColumns(ColumnsBean bean) {
        Column[] result = new Column[bean.columns.length];
        int i = 0;
        while (i < bean.columns.length) {
            ColumnBean cb = bean.columns[i];
            result[i] = new Column(cb.key, cb.label, Column.Align.valueOf((String)cb.alignment), cb.width, cb.tooltip, cb.grab, cb.weight);
            ++i;
        }
        return result;
    }

    @Override
    protected ModelBrowser doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
        String browseContext = (String)object.getJSONField("browseContext");
        if (browseContext == null) {
            return null;
        }
        String contextMenuId = (String)object.getJSONField("contextMenuId");
        Boolean displayFilter = (Boolean)object.getJSONField("displayFilter");
        Boolean displayHeader = (Boolean)object.getJSONField("displayHeader");
        Integer style = (Integer)object.getJSONField("style");
        if (style == null) {
            style = 65536;
        }
        StatePersistor persistor = (StatePersistor)object.getJSONField("persistor");
        final Function1 selectionListener = (Function1)object.getJSONField("selectionListener");
        DragSourceListenerFactory dragSourceListenerFactory = (DragSourceListenerFactory)object.getJSONField("dragSourceListenerFactory");
        IWorkbenchSite site = document.getSite();
        final ISelectionProvider selectionProvider = document.getSelectionProvider();
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("displaySelectors", Boolean.FALSE);
        args.put("displayFilter", displayFilter != null ? displayFilter : Boolean.FALSE);
        ColumnsBean columns = (ColumnsBean)object.getBeanJSONFieldDefault("columns", ColumnsBean.BINDING, null);
        String editingColumn = (String)object.getJSONFieldDefault("editingColumn", null);
        final ModelBrowser control = new ModelBrowser(Collections.singleton(browseContext), args, site, parent, (WidgetSupport)new WidgetSupportImpl(), style.intValue());
        Tree tree = (Tree)control.getExplorerControl();
        tree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                SWTViews.notifyScrolledComposite((Control)control);
            }
        });
        if (columns != null) {
            control.setColumns(this.getColumns(columns));
        }
        if (editingColumn != null) {
            control.setEditingColumn(new String[]{editingColumn});
        }
        if (contextMenuId != null) {
            control.setContextMenuId(contextMenuId);
        }
        if (dragSourceListenerFactory != null) {
            control.setDragSourceListenerFactory(dragSourceListenerFactory);
        }
        if (displayHeader != null) {
            tree.setHeaderVisible(displayHeader.booleanValue());
        }
        control.setStatePersistor(persistor);
        control.finish();
        control.setInputSource((GraphExplorerComposite.InputSource)new InputSourceImpl<Object>(){

            public Object get(ISessionContext ctx, Object selection) {
                return selection;
            }
        });
        Object i = object.getJSONField("explorerInput");
        if (i instanceof VariableBean) {
            control.setInput(Simantics.getSessionContext(), (Object)((VariableBean)i).getVariable());
        } else {
            control.setInput(Simantics.getSessionContext(), i);
        }
        control.addListenerToControl(13, new Listener(){

            public void handleEvent(Event event) {
                if (selectionListener != null) {
                    selectionListener.apply((Object)event);
                }
                ISelection selection = (ISelection)control.getExplorer().getWidgetSelection();
                if (selectionProvider != null) {
                    selectionProvider.setSelection(selection);
                }
            }
        });
        return control;
    }

    @Override
    public String getProperty(SWTDocument document, JSONObject object, WidgetContainer<ModelBrowser> widget, String property) {
        if ("selection".equals(property)) {
            ISelection selection = (ISelection)widget.getControl().getExplorer().getWidgetSelection();
            return SWTViews.encode(object, property, WorkbenchSelectionUtils.getWorkbenchSelectionElements((ISelection)selection));
        }
        return null;
    }
}

