/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core.selection;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.swt.PartNameListener;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.document.swt.core.SWTDocumentClient;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.IPropertyTab2;
import org.simantics.selectionview.PropertyTabContributor;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public final class DocumentTabContributor
implements PropertyTabContributor,
ListenerSupport {
    protected boolean disposed = false;
    protected ISelection input = StructuredSelection.EMPTY;
    protected final String documentURI;
    private SWTDocumentClient client;
    protected ISelectionProvider selectionProvider = new ActiveSelectionProvider();

    public DocumentTabContributor(String documentURI) {
        this.documentURI = documentURI;
    }

    public void createControls(Composite body, IWorkbenchSite site) {
        this.client = new SWTDocumentClient(SWTViews.getMapping(), this.selectionProvider, site, body);
    }

    public IFilterArea getFilterArea() {
        return null;
    }

    public void requestFocus() {
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Read<String> getPartNameReadRequest(ISelection forSelection) {
        return null;
    }

    public void updatePartName(ISelection forSelection, Callback<String> updateCallback) {
        Read<String> read = this.getPartNameReadRequest(forSelection);
        if (read == null) {
            updateCallback.run((Object)"Selection");
        } else {
            Simantics.getSession().asyncRequest(read, (org.simantics.db.procedure.Listener)new PartNameListener(updateCallback, (ListenerSupport)this));
        }
    }

    public void updatePartName(Callback<String> updateCallback) {
        this.updatePartName(this.input, updateCallback);
    }

    protected void dispose() {
        this.disposed = true;
    }

    public void exception(Throwable t) {
        ErrorLogger.defaultLogError((String)"PropertyTabContributorImpl received unexpected exception.", (Throwable)t);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void createControl(Composite parent, IWorkbenchSite site) {
        class TabComposite
        extends Composite {
            public TabComposite(Composite parent, IWorkbenchSite iWorkbenchSite) {
                super(parent, 0);
                GridLayoutFactory.fillDefaults().applyTo(parent);
                GridDataFactory.fillDefaults().span(1, 1).grab(true, true).applyTo((Control)this);
                TabComposite body = this;
                GridLayoutFactory.fillDefaults().spacing(0, 0).equalWidth(false).numColumns(1).applyTo((Composite)body);
                try {
                    DocumentTabContributor.this.createControls(body, iWorkbenchSite);
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }
            }
        }
        TabComposite tc = new TabComposite(parent, site);
        tc.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DocumentTabContributor.this.dispose();
            }
        });
    }

    public IPropertyTab create(Composite parent, IWorkbenchSite site, ISessionContext context, Object input) {
        Tab tab = new Tab(site, parent);
        tab.createControl((Composite)tab.getControl(), context);
        return tab;
    }

    public int hashCode() {
        return this.documentURI.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DocumentTabContributor)) {
            return false;
        }
        DocumentTabContributor dtc = (DocumentTabContributor)object;
        return this.documentURI.equals(dtc.documentURI);
    }

    class Tab
    extends Composite
    implements IPropertyTab2,
    IFilterAreaProvider {
        final IWorkbenchSite site;

        public Tab(IWorkbenchSite site, Composite parent) {
            super(parent, 0);
            this.site = site;
        }

        public void createControl(Composite parent, ISessionContext context) {
            DocumentTabContributor.this.createControl(parent, this.site);
        }

        public Control getControl() {
            return this;
        }

        public boolean isDisposed() {
            return super.isDisposed();
        }

        public void requestFocus() {
            DocumentTabContributor.this.requestFocus();
        }

        public void setInput(ISessionContext context, ISelection selection, boolean force) {
            DocumentTabContributor.this.input = selection;
            try {
                String input = (String)Simantics.getSession().syncRequest((Read)new UniqueRead<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        Variable var = (Variable)ISelectionUtils.filterSingleSelection((Object)((Tab)Tab.this).DocumentTabContributor.this.input, Variable.class);
                        if (var == null) {
                            return null;
                        }
                        return var.getURI(graph).substring("http:/".length());
                    }
                });
                ListenerSupport support = new ListenerSupport(){

                    public void exception(Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }

                    public boolean isDisposed() {
                        return DocumentTabContributor.this.isDisposed();
                    }
                };
                if (input != null) {
                    DocumentTabContributor.this.client.track(support, DocumentTabContributor.this.documentURI, input);
                    this.layout(true, true);
                }
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }

        public ISelectionProvider getSelectionProvider() {
            return DocumentTabContributor.this.getSelectionProvider();
        }

        public IFilterArea getFilterArea() {
            return DocumentTabContributor.this.getFilterArea();
        }

        public void updatePartName(Callback<String> updateCallback) {
            DocumentTabContributor.this.updatePartName(DocumentTabContributor.this.input, updateCallback);
        }
    }
}

