/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Collections12 {
    public static final Map EMPTY_MAP = new EmptyMap();

    private Collections12() {
    }

    public static Map singletonMap(Object key, Object value) {
        return new SingletonMap(key, value);
    }

    public static List singletonList(Object o) {
        return new SingletonList(o);
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private EmptyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Set keySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Collection values() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set entrySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    private static class SingletonList
    extends AbstractList
    implements Serializable {
        private final Object element;

        SingletonList(Object obj) {
            this.element = obj;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object obj) {
            return Collections12.eq(obj, this.element);
        }

        @Override
        public Object get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return this.element;
        }
    }

    private static class SingletonMap
    extends AbstractMap
    implements Serializable {
        private final Object k;
        private final Object v;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        SingletonMap(Object key, Object value) {
            this.k = key;
            this.v = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return Collections12.eq(key, this.k);
        }

        @Override
        public boolean containsValue(Object value) {
            return Collections12.eq(value, this.v);
        }

        @Override
        public Object get(Object key) {
            return Collections12.eq(key, this.k) ? this.v : null;
        }

        @Override
        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        @Override
        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new ImmutableEntry(this.k, this.v));
            }
            return this.entrySet;
        }

        @Override
        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        private static class ImmutableEntry
        implements Map.Entry {
            final Object k;
            final Object v;

            ImmutableEntry(Object key, Object value) {
                this.k = key;
                this.v = value;
            }

            public Object getKey() {
                return this.k;
            }

            public Object getValue() {
                return this.v;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Collections12.eq(e.getKey(), this.k) && Collections12.eq(e.getValue(), this.v);
            }

            @Override
            public int hashCode() {
                return (this.k == null ? 0 : this.k.hashCode()) ^ (this.v == null ? 0 : this.v.hashCode());
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }
}

