/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.template.SettingStringParser;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.CaptureOutput;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.HtmlEscape;
import freemarker.template.utility.NormalizeNewlines;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.StandardCompress;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.XmlEscape;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Configuration
extends Configurable
implements Cloneable {
    public static final String DEFAULT_ENCODING_KEY = "default_encoding";
    public static final String LOCALIZED_LOOKUP_KEY = "localized_lookup";
    public static final String STRICT_SYNTAX_KEY = "strict_syntax";
    public static final String WHITESPACE_STRIPPING_KEY = "whitespace_stripping";
    public static final String CACHE_STORAGE_KEY = "cache_storage";
    public static final String TEMPLATE_UPDATE_DELAY_KEY = "template_update_delay";
    public static final String AUTO_IMPORT_KEY = "auto_import";
    public static final String AUTO_INCLUDE_KEY = "auto_include";
    public static final String TAG_SYNTAX_KEY = "tag_syntax";
    public static final int AUTO_DETECT_TAG_SYNTAX = 0;
    public static final int ANGLE_BRACKET_TAG_SYNTAX = 1;
    public static final int SQUARE_BRACKET_TAG_SYNTAX = 2;
    private static Configuration defaultConfig = new Configuration();
    private static String cachedVersion;
    private boolean strictSyntax = true;
    private boolean localizedLookup = true;
    private boolean whitespaceStripping = true;
    private int tagSyntax = 1;
    private TemplateCache cache;
    private HashMap variables = new HashMap();
    private HashMap encodingMap = new HashMap();
    private Map autoImportMap = new HashMap();
    private ArrayList autoImports = new ArrayList();
    private ArrayList autoIncludes = new ArrayList();
    private String defaultEncoding = SecurityUtilities.getSystemProperty("file.encoding");

    public Configuration() {
        this.cache = new TemplateCache();
        this.cache.setConfiguration(this);
        this.cache.setDelay(5000L);
        this.loadBuiltInSharedVariables();
    }

    @Override
    public Object clone() {
        try {
            Configuration copy = (Configuration)super.clone();
            copy.variables = new HashMap(this.variables);
            copy.encodingMap = new HashMap(this.encodingMap);
            copy.createTemplateCache(this.cache.getTemplateLoader(), this.cache.getCacheStorage());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone is not supported, but it should be: " + e.getMessage());
        }
    }

    private void loadBuiltInSharedVariables() {
        this.variables.put("capture_output", new CaptureOutput());
        this.variables.put("compress", StandardCompress.INSTANCE);
        this.variables.put("html_escape", new HtmlEscape());
        this.variables.put("normalize_newlines", new NormalizeNewlines());
        this.variables.put("xml_escape", new XmlEscape());
    }

    public void loadBuiltInEncodingMap() {
        this.encodingMap.clear();
        this.encodingMap.put("ar", "ISO-8859-6");
        this.encodingMap.put("be", "ISO-8859-5");
        this.encodingMap.put("bg", "ISO-8859-5");
        this.encodingMap.put("ca", "ISO-8859-1");
        this.encodingMap.put("cs", "ISO-8859-2");
        this.encodingMap.put("da", "ISO-8859-1");
        this.encodingMap.put("de", "ISO-8859-1");
        this.encodingMap.put("el", "ISO-8859-7");
        this.encodingMap.put("en", "ISO-8859-1");
        this.encodingMap.put("es", "ISO-8859-1");
        this.encodingMap.put("et", "ISO-8859-1");
        this.encodingMap.put("fi", "ISO-8859-1");
        this.encodingMap.put("fr", "ISO-8859-1");
        this.encodingMap.put("hr", "ISO-8859-2");
        this.encodingMap.put("hu", "ISO-8859-2");
        this.encodingMap.put("is", "ISO-8859-1");
        this.encodingMap.put("it", "ISO-8859-1");
        this.encodingMap.put("iw", "ISO-8859-8");
        this.encodingMap.put("ja", "Shift_JIS");
        this.encodingMap.put("ko", "EUC-KR");
        this.encodingMap.put("lt", "ISO-8859-2");
        this.encodingMap.put("lv", "ISO-8859-2");
        this.encodingMap.put("mk", "ISO-8859-5");
        this.encodingMap.put("nl", "ISO-8859-1");
        this.encodingMap.put("no", "ISO-8859-1");
        this.encodingMap.put("pl", "ISO-8859-2");
        this.encodingMap.put("pt", "ISO-8859-1");
        this.encodingMap.put("ro", "ISO-8859-2");
        this.encodingMap.put("ru", "ISO-8859-5");
        this.encodingMap.put("sh", "ISO-8859-5");
        this.encodingMap.put("sk", "ISO-8859-2");
        this.encodingMap.put("sl", "ISO-8859-2");
        this.encodingMap.put("sq", "ISO-8859-2");
        this.encodingMap.put("sr", "ISO-8859-5");
        this.encodingMap.put("sv", "ISO-8859-1");
        this.encodingMap.put("tr", "ISO-8859-9");
        this.encodingMap.put("uk", "ISO-8859-5");
        this.encodingMap.put("zh", "GB2312");
        this.encodingMap.put("zh_TW", "Big5");
    }

    public void clearEncodingMap() {
        this.encodingMap.clear();
    }

    public static Configuration getDefaultConfiguration() {
        return defaultConfig;
    }

    public static void setDefaultConfiguration(Configuration config) {
        defaultConfig = config;
    }

    public synchronized void setTemplateLoader(TemplateLoader loader) {
        this.createTemplateCache(loader, this.cache.getCacheStorage());
    }

    private void createTemplateCache(TemplateLoader loader, CacheStorage storage) {
        TemplateCache oldCache = this.cache;
        this.cache = new TemplateCache(loader, storage);
        this.cache.setDelay(oldCache.getDelay());
        this.cache.setConfiguration(this);
        this.cache.setLocalizedLookup(this.localizedLookup);
    }

    public TemplateLoader getTemplateLoader() {
        return this.cache.getTemplateLoader();
    }

    public synchronized void setCacheStorage(CacheStorage storage) {
        this.createTemplateCache(this.cache.getTemplateLoader(), storage);
    }

    public void setDirectoryForTemplateLoading(File dir) throws IOException {
        String path;
        TemplateLoader tl = this.getTemplateLoader();
        if (tl instanceof FileTemplateLoader && (path = ((FileTemplateLoader)tl).baseDir.getCanonicalPath()).equals(dir.getCanonicalPath())) {
            return;
        }
        this.setTemplateLoader(new FileTemplateLoader(dir));
    }

    public void setServletContextForTemplateLoading(Object sctxt, String path) {
        try {
            if (path == null) {
                this.setTemplateLoader((TemplateLoader)ClassUtil.forName("freemarker.cache.WebappTemplateLoader").getConstructor(ClassUtil.forName("javax.servlet.ServletContext")).newInstance(sctxt));
            } else {
                this.setTemplateLoader((TemplateLoader)ClassUtil.forName("freemarker.cache.WebappTemplateLoader").getConstructor(ClassUtil.forName("javax.servlet.ServletContext"), String.class).newInstance(sctxt, path));
            }
        }
        catch (Exception exc) {
            throw new RuntimeException("Internal FreeMarker error: " + exc);
        }
    }

    public void setClassForTemplateLoading(Class clazz, String pathPrefix) {
        this.setTemplateLoader(new ClassTemplateLoader(clazz, pathPrefix));
    }

    public void setTemplateUpdateDelay(int delay) {
        this.cache.setDelay(1000L * (long)delay);
    }

    public void setStrictSyntaxMode(boolean b) {
        this.strictSyntax = b;
    }

    public boolean getStrictSyntaxMode() {
        return this.strictSyntax;
    }

    public void setWhitespaceStripping(boolean b) {
        this.whitespaceStripping = b;
    }

    public boolean getWhitespaceStripping() {
        return this.whitespaceStripping;
    }

    public void setTagSyntax(int tagSyntax) {
        if (tagSyntax != 0 && tagSyntax != 2 && tagSyntax != 1) {
            throw new IllegalArgumentException("This can only be set to one of three settings: Configuration.AUTO_DETECT_TAG_SYNTAX, Configuration.ANGLE_BRACKET_SYNTAX, or Configuration.SQAUARE_BRACKET_SYNTAX");
        }
        this.tagSyntax = tagSyntax;
    }

    public int getTagSyntax() {
        return this.tagSyntax;
    }

    public Template getTemplate(String name) throws IOException {
        Locale loc = this.getLocale();
        return this.getTemplate(name, loc, this.getEncoding(loc), true);
    }

    public Template getTemplate(String name, Locale locale) throws IOException {
        return this.getTemplate(name, locale, this.getEncoding(locale), true);
    }

    public Template getTemplate(String name, String encoding) throws IOException {
        return this.getTemplate(name, this.getLocale(), encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding) throws IOException {
        return this.getTemplate(name, locale, encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parse) throws IOException {
        Template result = this.cache.getTemplate(name, locale, encoding, parse);
        if (result == null) {
            throw new FileNotFoundException("Template " + name + " not found.");
        }
        return result;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding(Locale loc) {
        String charset = (String)this.encodingMap.get(loc.toString());
        if (charset == null) {
            Locale l;
            if (loc.getVariant().length() > 0 && (charset = (String)this.encodingMap.get((l = new Locale(loc.getLanguage(), loc.getCountry())).toString())) != null) {
                this.encodingMap.put(loc.toString(), charset);
            }
            if ((charset = (String)this.encodingMap.get(loc.getLanguage())) != null) {
                this.encodingMap.put(loc.toString(), charset);
            }
        }
        return charset != null ? charset : this.defaultEncoding;
    }

    public void setEncoding(Locale locale, String encoding) {
        this.encodingMap.put(locale.toString(), encoding);
    }

    public void setSharedVariable(String name, TemplateModel tm) {
        this.variables.put(name, tm);
    }

    public Set getSharedVariableNames() {
        return new HashSet(this.variables.keySet());
    }

    public void setSharedVariable(String name, Object obj) throws TemplateModelException {
        this.setSharedVariable(name, this.getObjectWrapper().wrap(obj));
    }

    public void setAllSharedVariables(TemplateHashModelEx hash) throws TemplateModelException {
        TemplateModelIterator keys = hash.keys().iterator();
        TemplateModelIterator values = hash.values().iterator();
        while (keys.hasNext()) {
            this.setSharedVariable(((TemplateScalarModel)keys.next()).getAsString(), values.next());
        }
    }

    public TemplateModel getSharedVariable(String name) {
        return (TemplateModel)this.variables.get(name);
    }

    public void clearSharedVariables() {
        this.variables.clear();
        this.loadBuiltInSharedVariables();
    }

    public void clearTemplateCache() {
        this.cache.clear();
    }

    public boolean getLocalizedLookup() {
        return this.cache.getLocalizedLookup();
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
        this.cache.setLocalizedLookup(localizedLookup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSetting(String key, String value) throws TemplateException {
        if ("TemplateUpdateInterval".equalsIgnoreCase(key)) {
            key = TEMPLATE_UPDATE_DELAY_KEY;
        } else if ("DefaultEncoding".equalsIgnoreCase(key)) {
            key = DEFAULT_ENCODING_KEY;
        }
        try {
            if (DEFAULT_ENCODING_KEY.equals(key)) {
                this.setDefaultEncoding(value);
                return;
            }
            if (LOCALIZED_LOOKUP_KEY.equals(key)) {
                this.setLocalizedLookup(StringUtil.getYesNo(value));
                return;
            }
            if (STRICT_SYNTAX_KEY.equals(key)) {
                this.setStrictSyntaxMode(StringUtil.getYesNo(value));
                return;
            }
            if (WHITESPACE_STRIPPING_KEY.equals(key)) {
                this.setWhitespaceStripping(StringUtil.getYesNo(value));
                return;
            }
            if (CACHE_STORAGE_KEY.equals(key)) {
                if (value.indexOf(46) == -1) {
                    int strongSize = 0;
                    int softSize = 0;
                    Map map = StringUtil.parseNameValuePairList(value, String.valueOf(Integer.MAX_VALUE));
                    for (Map.Entry ent : map.entrySet()) {
                        int pvalue;
                        String pname = (String)ent.getKey();
                        try {
                            pvalue = Integer.parseInt((String)ent.getValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.invalidSettingValueException(key, value);
                        }
                        if ("soft".equalsIgnoreCase(pname)) {
                            softSize = pvalue;
                            continue;
                        }
                        if (!"strong".equalsIgnoreCase(pname)) throw this.invalidSettingValueException(key, value);
                        strongSize = pvalue;
                    }
                    if (softSize == 0 && strongSize == 0) {
                        throw this.invalidSettingValueException(key, value);
                    }
                    this.setCacheStorage(new MruCacheStorage(strongSize, softSize));
                    return;
                }
                this.setCacheStorage((CacheStorage)ClassUtil.forName(value).newInstance());
                return;
            }
            if (TEMPLATE_UPDATE_DELAY_KEY.equals(key)) {
                this.setTemplateUpdateDelay(Integer.parseInt(value));
                return;
            } else if (AUTO_INCLUDE_KEY.equals(key)) {
                this.setAutoIncludes(new SettingStringParser(value).parseAsList());
                return;
            } else if (AUTO_IMPORT_KEY.equals(key)) {
                this.setAutoImports(new SettingStringParser(value).parseAsImportList());
                return;
            } else if (TAG_SYNTAX_KEY.equals(key)) {
                if ("auto_detect".equals(value)) {
                    this.setTagSyntax(0);
                    return;
                } else if ("angle_bracket".equals(value)) {
                    this.setTagSyntax(1);
                    return;
                } else {
                    if (!"square_bracket".equals(value)) throw this.invalidSettingValueException(key, value);
                    this.setTagSyntax(2);
                }
                return;
            } else {
                super.setSetting(key, value);
            }
            return;
        }
        catch (Exception e) {
            throw new TemplateException("Failed to set setting " + key + " to value " + value, e, this.getEnvironment());
        }
    }

    public synchronized void addAutoImport(String namespace, String template) {
        this.autoImports.remove(namespace);
        this.autoImports.add(namespace);
        this.autoImportMap.put(namespace, template);
    }

    public synchronized void removeAutoImport(String namespace) {
        this.autoImports.remove(namespace);
        this.autoImportMap.remove(namespace);
    }

    public synchronized void setAutoImports(Map map) {
        this.autoImports = new ArrayList(map.keySet());
        this.autoImportMap = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof SortedMap ? new TreeMap(map) : new HashMap(map));
    }

    @Override
    protected void doAutoImportsAndIncludes(Environment env) throws TemplateException, IOException {
        int i = 0;
        while (i < this.autoImports.size()) {
            String namespace = (String)this.autoImports.get(i);
            String templateName = (String)this.autoImportMap.get(namespace);
            env.importLib(templateName, namespace);
            ++i;
        }
        i = 0;
        while (i < this.autoIncludes.size()) {
            String templateName = (String)this.autoIncludes.get(i);
            Template template = this.getTemplate(templateName, env.getLocale());
            env.include(template);
            ++i;
        }
    }

    public synchronized void addAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
        this.autoIncludes.add(templateName);
    }

    public synchronized void setAutoIncludes(List templateNames) {
        this.autoIncludes.clear();
        for (Object o : templateNames) {
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("List items must be String-s.");
            }
            this.autoIncludes.add(o);
        }
    }

    public synchronized void removeAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
    }

    public static String getVersionNumber() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        try {
            Properties vp = new Properties();
            InputStream ins = Configuration.class.getClassLoader().getResourceAsStream("freemarker/version.properties");
            if (ins == null) {
                throw new RuntimeException("Version file is missing.");
            }
            try {
                vp.load(ins);
            }
            finally {
                ins.close();
            }
            String v = vp.getProperty("version");
            if (v == null) {
                throw new RuntimeException("Version file is corrupt: version key is missing.");
            }
            cachedVersion = v;
            return cachedVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load version file: " + e);
        }
    }
}

