/*
 * Decompiled with CFR 0.152.
 */
package freemarker.log;

import freemarker.log.LoggerFactory;
import freemarker.log.NullLoggerFactory;
import freemarker.template.utility.ClassUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class Logger {
    public static final int LIBRARY_AUTO = -1;
    public static final int LIBRARY_NONE = 0;
    public static final int LIBRARY_JAVA = 1;
    public static final int LIBRARY_AVALON = 2;
    public static final int LIBRARY_LOG4J = 3;
    private static final String[] LIBINIT = new String[]{"freemarker.log", "Null", "java.util.logging", "JDK14", "org.apache.log", "Avalon", "org.apache.log4j", "Log4J"};
    private static int logLibrary;
    private static LoggerFactory factory;
    private static String categoryPrefix;
    private static final Map loggers;

    static {
        categoryPrefix = "";
        loggers = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectLoggerLibrary(int library) throws ClassNotFoundException {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (library < -1 || library * 2 >= LIBINIT.length) {
                throw new IllegalArgumentException();
            }
            logLibrary = library;
            factory = Logger.createFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCategoryPrefix(String prefix) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            categoryPrefix = prefix;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Logger getLogger(String category) {
        Object object;
        if (factory == null) {
            object = Logger.class;
            // MONITORENTER : freemarker.log.Logger.class
            if (factory == null) {
                try {
                    Logger.selectLoggerLibrary(-1);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            // MONITOREXIT : object
        }
        category = String.valueOf(categoryPrefix) + category;
        object = loggers;
        // MONITORENTER : object
        Logger logger = (Logger)loggers.get(category);
        if (logger == null) {
            logger = factory.getLogger(category);
            loggers.put(category, logger);
        }
        // MONITOREXIT : object
        return logger;
    }

    private static LoggerFactory createFactory() throws ClassNotFoundException {
        if (logLibrary == -1) {
            int i = LIBINIT.length / 2 - 1;
            while (i > 0) {
                try {
                    return Logger.createFactory(i);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    --i;
                }
            }
            System.err.println("*** WARNING: FreeMarker logging suppressed.");
            return new NullLoggerFactory();
        }
        return Logger.createFactory(logLibrary);
    }

    private static LoggerFactory createFactory(int library) throws ClassNotFoundException {
        String requiredPackage = LIBINIT[library * 2];
        String factoryType = LIBINIT[library * 2 + 1];
        try {
            ClassUtil.forName(String.valueOf(requiredPackage) + ".Logger");
            return (LoggerFactory)Class.forName("freemarker.log." + factoryType + "LoggerFactory").newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
    }
}

