/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.OverloadedMethodModel;
import freemarker.ext.beans.SimpleMethodModel;
import freemarker.log.Logger;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

final class StaticModel
implements TemplateHashModelEx {
    private static final Logger logger = Logger.getLogger("freemarker.beans");
    private final Class clazz;
    private final BeansWrapper wrapper;
    private final Map map = new HashMap();

    StaticModel(Class clazz, BeansWrapper wrapper) throws TemplateModelException {
        this.clazz = clazz;
        this.wrapper = wrapper;
        this.populate();
    }

    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        Object model = this.map.get(key);
        if (model instanceof TemplateModel) {
            return (TemplateModel)model;
        }
        if (model instanceof Field) {
            try {
                return this.wrapper.getOuterIdentity().wrap(((Field)model).get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TemplateModelException("Illegal access for field " + key + " of class " + this.clazz.getName());
            }
        }
        throw new TemplateModelException("No such key: " + key + " in class " + this.clazz.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.keySet());
    }

    @Override
    public TemplateCollectionModel values() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.values());
    }

    private void populate() throws TemplateModelException {
        if (!Modifier.isPublic(this.clazz.getModifiers())) {
            throw new TemplateModelException("Can't wrap the non-public class " + this.clazz.getName());
        }
        if (this.wrapper.getExposureLevel() == 3) {
            return;
        }
        Field[] fields = this.clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int n = field.getModifiers();
            if (Modifier.isPublic(n) && Modifier.isStatic(n)) {
                if (Modifier.isFinal(n)) {
                    try {
                        this.map.put(field.getName(), this.wrapper.getOuterIdentity().wrap(field.get(null)));
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                } else {
                    this.map.put(field.getName(), field);
                }
            }
            ++i;
        }
        if (this.wrapper.getExposureLevel() < 2) {
            Method[] methods = this.clazz.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                Method method = methods[i2];
                int mod = method.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && this.wrapper.isSafeMethod(method)) {
                    MethodMap methodMap;
                    String name = method.getName();
                    Object obj = this.map.get(name);
                    if (obj instanceof Method) {
                        methodMap = new MethodMap(name, this.wrapper);
                        methodMap.addMember((Method)obj);
                        methodMap.addMember(method);
                        this.map.put(name, methodMap);
                    } else if (obj instanceof MethodMap) {
                        methodMap = (MethodMap)obj;
                        methodMap.addMember(method);
                    } else {
                        if (obj != null) {
                            logger.info("Overwriting value [" + obj + "] for " + " key '" + name + "' with [" + method + "] in static model for " + this.clazz.getName());
                        }
                        this.map.put(name, method);
                    }
                }
                ++i2;
            }
            for (Map.Entry entry : this.map.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Method) {
                    Method method = (Method)value;
                    entry.setValue(new SimpleMethodModel(null, method, method.getParameterTypes(), this.wrapper));
                    continue;
                }
                if (!(value instanceof MethodMap)) continue;
                entry.setValue(new OverloadedMethodModel(null, (MethodMap)value));
            }
        }
    }
}

