/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.MethodUtilities;
import freemarker.ext.beans.OverloadedMethod;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class ClassString {
    private static final Class BIGDECIMAL_CLASS = BigDecimal.class;
    private static final Class NUMBER_CLASS = Number.class;
    private final Class[] classes;
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INDETERMINATE = 2;

    ClassString(Object[] objects) {
        int l = objects.length;
        this.classes = new Class[l];
        int i = 0;
        while (i < l) {
            Object obj = objects[i];
            this.classes[i] = obj == null ? MethodUtilities.OBJECT_CLASS : obj.getClass();
            ++i;
        }
    }

    Class[] getClasses() {
        return this.classes;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.classes.length) {
            hash ^= this.classes[i].hashCode();
            ++i;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof ClassString) {
            ClassString cs = (ClassString)o;
            if (cs.classes.length != this.classes.length) {
                return false;
            }
            int i = 0;
            while (i < this.classes.length) {
                if (cs.classes[i] != this.classes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    Object getMostSpecific(List methods, boolean varArg) {
        LinkedList applicables = this.getApplicables(methods, varArg);
        if (applicables.isEmpty()) {
            return OverloadedMethod.NO_SUCH_METHOD;
        }
        if (applicables.size() == 1) {
            return applicables.getFirst();
        }
        LinkedList<Member> maximals = new LinkedList<Member>();
        for (Member applicable : applicables) {
            Class[] appArgs = MethodUtilities.getParameterTypes(applicable);
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            while (maximal.hasNext()) {
                Member max = (Member)maximal.next();
                Class[] maxArgs = MethodUtilities.getParameterTypes(max);
                switch (ClassString.moreSpecific(appArgs, maxArgs, varArg)) {
                    case 0: {
                        maximal.remove();
                        break;
                    }
                    case 1: {
                        lessSpecific = true;
                    }
                }
            }
            if (lessSpecific) continue;
            maximals.addLast(applicable);
        }
        if (maximals.size() > 1) {
            return OverloadedMethod.AMBIGUOUS_METHOD;
        }
        return maximals.getFirst();
    }

    private static int moreSpecific(Class[] c1, Class[] c2, boolean varArg) {
        boolean c1MoreSpecific = false;
        boolean c2MoreSpecific = false;
        int cl1 = c1.length;
        int cl2 = c2.length;
        int i = 0;
        while (i < cl1) {
            Class class2;
            Class class1 = ClassString.getClass(c1, cl1, i, varArg);
            if (class1 != (class2 = ClassString.getClass(c2, cl2, i, varArg))) {
                c1MoreSpecific = c1MoreSpecific || MethodUtilities.isMoreSpecific(class1, class2);
                c2MoreSpecific = c2MoreSpecific || MethodUtilities.isMoreSpecific(class2, class1);
            }
            ++i;
        }
        if (c1MoreSpecific) {
            if (c2MoreSpecific) {
                return 2;
            }
            return 0;
        }
        if (c2MoreSpecific) {
            return 1;
        }
        return 2;
    }

    private static Class getClass(Class[] classes, int l, int i, boolean varArg) {
        return varArg && i >= l - 1 ? classes[l - 1].getComponentType() : classes[i];
    }

    LinkedList getApplicables(List methods, boolean varArg) {
        LinkedList<Member> list = new LinkedList<Member>();
        for (Member member : methods) {
            if (!this.isApplicable(member, varArg)) continue;
            list.add(member);
        }
        return list;
    }

    private boolean isApplicable(Member member, boolean varArg) {
        Class[] formalTypes = MethodUtilities.getParameterTypes(member);
        int cl = this.classes.length;
        int fl = formalTypes.length - (varArg ? 1 : 0);
        if (varArg ? cl < fl : cl != fl) {
            return false;
        }
        int i = 0;
        while (i < fl) {
            if (!ClassString.isMethodInvocationConvertible(formalTypes[i], this.classes[i])) {
                return false;
            }
            ++i;
        }
        if (varArg) {
            Class<?> varArgType = formalTypes[fl].getComponentType();
            int i2 = fl;
            while (i2 < cl) {
                if (!ClassString.isMethodInvocationConvertible(varArgType, this.classes[i2])) {
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    static boolean isMethodInvocationConvertible(Class formal, Class actual) {
        if (formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE) {
                return actual == Boolean.class;
            }
            if (formal == Character.TYPE) {
                return actual == Character.class;
            }
            if (formal == Byte.TYPE && actual == Byte.class) {
                return true;
            }
            if (formal == Short.TYPE && (actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            return ClassString.isBigDecimalConvertible(formal, actual);
        }
        return false;
    }

    private static boolean isBigDecimalConvertible(Class formal, Class actual) {
        if (BIGDECIMAL_CLASS.isAssignableFrom(actual)) {
            if (NUMBER_CLASS.isAssignableFrom(formal)) {
                return true;
            }
            if (formal.isPrimitive() && formal != Boolean.TYPE && formal != Character.TYPE) {
                return true;
            }
        }
        return false;
    }
}

