/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.ArrayModel;
import freemarker.ext.beans.BeansModelCache;
import freemarker.ext.beans.BooleanModel;
import freemarker.ext.beans.ClassBasedModelFactory;
import freemarker.ext.beans.CollectionAdapter;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.beans.DateModel;
import freemarker.ext.beans.EnumerationModel;
import freemarker.ext.beans.HashAdapter;
import freemarker.ext.beans.IteratorModel;
import freemarker.ext.beans.MapModel;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.NumberModel;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.ext.beans.SequenceAdapter;
import freemarker.ext.beans.SetAdapter;
import freemarker.ext.beans.SimpleMapModel;
import freemarker.ext.beans.SimpleMemberModel;
import freemarker.ext.beans.StaticModels;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.IdentityHashMap;
import freemarker.ext.util.ModelCache;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.log.Logger;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.Collections12;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.UndeclaredThrowableException;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class BeansWrapper
implements ObjectWrapper {
    public static final Object CAN_NOT_UNWRAP;
    private static final Class BIGINTEGER_CLASS;
    private static final Class BOOLEAN_CLASS;
    private static final Class CHARACTER_CLASS;
    private static final Class COLLECTION_CLASS;
    private static final Class DATE_CLASS;
    private static final Class HASHADAPTER_CLASS;
    private static final Class ITERABLE_CLASS;
    private static final Class LIST_CLASS;
    private static final Class MAP_CLASS;
    private static final Class NUMBER_CLASS;
    private static final Class OBJECT_CLASS;
    private static final Class SEQUENCEADAPTER_CLASS;
    private static final Class SET_CLASS;
    private static final Class SETADAPTER_CLASS;
    private static final Class STRING_CLASS;
    private static final boolean DEVELOPMENT;
    private static final Constructor ENUMS_MODEL_CTOR;
    private static final Logger logger;
    private static final Set UNSAFE_METHODS;
    static final Object GENERIC_GET_KEY;
    private static final Object CONSTRUCTORS;
    private static final Object ARGTYPES;
    private static final BeansWrapper INSTANCE;
    private final Map classCache = new HashMap();
    private Set cachedClassNames = new HashSet();
    private final StaticModels staticModels = new StaticModels(this);
    private final ClassBasedModelFactory enumModels = BeansWrapper.createEnumModels(this);
    private final ModelCache modelCache = new BeansModelCache(this);
    private final BooleanModel FALSE = new BooleanModel(Boolean.FALSE, this);
    private final BooleanModel TRUE = new BooleanModel(Boolean.TRUE, this);
    public static final int EXPOSE_ALL = 0;
    public static final int EXPOSE_SAFE = 1;
    public static final int EXPOSE_PROPERTIES_ONLY = 2;
    public static final int EXPOSE_NOTHING = 3;
    private int exposureLevel = 1;
    private TemplateModel nullModel = null;
    private boolean methodsShadowItems = true;
    private boolean exposeFields = false;
    private int defaultDateType = 0;
    private ObjectWrapper outerIdentity = this;
    private boolean simpleMapWrapper;
    private boolean strict = false;
    private final ModelFactory BOOLEAN_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return (Boolean)object != false ? BeansWrapper.this.TRUE : BeansWrapper.this.FALSE;
        }
    };
    private static final ModelFactory ITERATOR_FACTORY;
    private static final ModelFactory ENUMERATION_FACTORY;

    static {
        Class<?> iterable;
        CAN_NOT_UNWRAP = new Object();
        BIGINTEGER_CLASS = BigInteger.class;
        BOOLEAN_CLASS = Boolean.class;
        CHARACTER_CLASS = Character.class;
        COLLECTION_CLASS = Collection.class;
        DATE_CLASS = Date.class;
        HASHADAPTER_CLASS = HashAdapter.class;
        LIST_CLASS = List.class;
        MAP_CLASS = Map.class;
        NUMBER_CLASS = Number.class;
        OBJECT_CLASS = Object.class;
        SEQUENCEADAPTER_CLASS = SequenceAdapter.class;
        SET_CLASS = Set.class;
        SETADAPTER_CLASS = SetAdapter.class;
        STRING_CLASS = String.class;
        try {
            iterable = Class.forName("java.lang.Iterable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            iterable = null;
        }
        ITERABLE_CLASS = iterable;
        DEVELOPMENT = "true".equals(SecurityUtilities.getSystemProperty("freemarker.development"));
        ENUMS_MODEL_CTOR = BeansWrapper.enumsModelCtor();
        logger = Logger.getLogger("freemarker.beans");
        UNSAFE_METHODS = BeansWrapper.createUnsafeMethodsSet();
        GENERIC_GET_KEY = new Object();
        CONSTRUCTORS = new Object();
        ARGTYPES = new Object();
        INSTANCE = new BeansWrapper();
        ITERATOR_FACTORY = new ModelFactory(){

            @Override
            public TemplateModel create(Object object, ObjectWrapper wrapper) {
                return new IteratorModel((Iterator)object, (BeansWrapper)wrapper);
            }
        };
        ENUMERATION_FACTORY = new ModelFactory(){

            @Override
            public TemplateModel create(Object object, ObjectWrapper wrapper) {
                return new EnumerationModel((Enumeration)object, (BeansWrapper)wrapper);
            }
        };
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setOuterIdentity(ObjectWrapper outerIdentity) {
        this.outerIdentity = outerIdentity;
    }

    public ObjectWrapper getOuterIdentity() {
        return this.outerIdentity;
    }

    public void setSimpleMapWrapper(boolean simpleMapWrapper) {
        this.simpleMapWrapper = simpleMapWrapper;
    }

    public boolean isSimpleMapWrapper() {
        return this.simpleMapWrapper;
    }

    public void setExposureLevel(int exposureLevel) {
        if (exposureLevel < 0 || exposureLevel > 3) {
            throw new IllegalArgumentException("Illegal exposure level " + exposureLevel);
        }
        this.exposureLevel = exposureLevel;
    }

    int getExposureLevel() {
        return this.exposureLevel;
    }

    public void setExposeFields(boolean exposeFields) {
        this.exposeFields = exposeFields;
    }

    public boolean isExposeFields() {
        return this.exposeFields;
    }

    public synchronized void setMethodsShadowItems(boolean methodsShadowItems) {
        this.methodsShadowItems = methodsShadowItems;
    }

    boolean isMethodsShadowItems() {
        return this.methodsShadowItems;
    }

    public synchronized void setDefaultDateType(int defaultDateType) {
        this.defaultDateType = defaultDateType;
    }

    protected int getDefaultDateType() {
        return this.defaultDateType;
    }

    public void setUseCache(boolean useCache) {
        this.modelCache.setUseCache(useCache);
    }

    public void setNullModel(TemplateModel nullModel) {
        this.nullModel = nullModel;
    }

    public static final BeansWrapper getDefaultInstance() {
        return INSTANCE;
    }

    @Override
    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object == null) {
            return this.nullModel;
        }
        return this.modelCache.getInstance(object);
    }

    protected TemplateModel getInstance(Object object, ModelFactory factory) {
        return factory.create(object, this);
    }

    protected ModelFactory getModelFactory(Class clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return this.simpleMapWrapper ? SimpleMapModel.FACTORY : MapModel.FACTORY;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return CollectionModel.FACTORY;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NumberModel.FACTORY;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DateModel.FACTORY;
        }
        if (Boolean.class == clazz) {
            return this.BOOLEAN_FACTORY;
        }
        if (ResourceBundle.class.isAssignableFrom(clazz)) {
            return ResourceBundleModel.FACTORY;
        }
        if (Iterator.class.isAssignableFrom(clazz)) {
            return ITERATOR_FACTORY;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return ENUMERATION_FACTORY;
        }
        if (clazz.isArray()) {
            return ArrayModel.FACTORY;
        }
        return StringModel.FACTORY;
    }

    public Object unwrap(TemplateModel model) throws TemplateModelException {
        return this.unwrap(model, OBJECT_CLASS);
    }

    public Object unwrap(TemplateModel model, Class hint) throws TemplateModelException {
        return this.unwrap(model, hint, null);
    }

    private Object unwrap(TemplateModel model, Class hint, Map recursionStops) throws TemplateModelException {
        Date date;
        Number number;
        Number number2;
        boolean isChar;
        if (model == this.nullModel) {
            return null;
        }
        boolean isBoolean = Boolean.TYPE == hint;
        boolean bl = isChar = Character.TYPE == hint;
        if (model instanceof AdapterTemplateModel) {
            Object adapted = ((AdapterTemplateModel)model).getAdaptedObject(hint);
            if (hint.isInstance(adapted)) {
                return adapted;
            }
            if (adapted instanceof Number && (hint.isPrimitive() && !isChar && !isBoolean || NUMBER_CLASS.isAssignableFrom(hint)) && (number2 = BeansWrapper.convertUnwrappedNumber(hint, (Number)adapted)) != null) {
                return number2;
            }
        }
        if (model instanceof WrapperTemplateModel) {
            Object wrapped = ((WrapperTemplateModel)model).getWrappedObject();
            if (hint.isInstance(wrapped)) {
                return wrapped;
            }
            if (wrapped instanceof Number && (hint.isPrimitive() && !isChar && !isBoolean || NUMBER_CLASS.isAssignableFrom(hint)) && (number2 = BeansWrapper.convertUnwrappedNumber(hint, (Number)wrapped)) != null) {
                return number2;
            }
        }
        if (STRING_CLASS == hint) {
            if (model instanceof TemplateScalarModel) {
                return ((TemplateScalarModel)model).getAsString();
            }
            return CAN_NOT_UNWRAP;
        }
        if ((hint.isPrimitive() && !isChar && !isBoolean || NUMBER_CLASS.isAssignableFrom(hint)) && model instanceof TemplateNumberModel && (number = BeansWrapper.convertUnwrappedNumber(hint, ((TemplateNumberModel)model).getAsNumber())) != null) {
            return number;
        }
        if (isBoolean || BOOLEAN_CLASS == hint) {
            if (model instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)model).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            return CAN_NOT_UNWRAP;
        }
        if (MAP_CLASS == hint && model instanceof TemplateHashModel) {
            return new HashAdapter((TemplateHashModel)model, this);
        }
        if (LIST_CLASS == hint && model instanceof TemplateSequenceModel) {
            return new SequenceAdapter((TemplateSequenceModel)model, this);
        }
        if (SET_CLASS == hint && model instanceof TemplateCollectionModel) {
            return new SetAdapter((TemplateCollectionModel)model, this);
        }
        if (COLLECTION_CLASS == hint || ITERABLE_CLASS == hint) {
            if (model instanceof TemplateCollectionModel) {
                return new CollectionAdapter((TemplateCollectionModel)model, this);
            }
            if (model instanceof TemplateSequenceModel) {
                return new SequenceAdapter((TemplateSequenceModel)model, this);
            }
        }
        if (hint.isArray()) {
            if (model instanceof TemplateSequenceModel) {
                if (recursionStops != null) {
                    Object retval = recursionStops.get(model);
                    if (retval != null) {
                        return retval;
                    }
                } else {
                    recursionStops = new IdentityHashMap();
                }
                TemplateSequenceModel seq = (TemplateSequenceModel)model;
                Class<?> componentType = hint.getComponentType();
                Object array = Array.newInstance(componentType, seq.size());
                recursionStops.put(model, array);
                try {
                    int size = seq.size();
                    int i = 0;
                    while (i < size) {
                        Object val = this.unwrap(seq.get(i), componentType, recursionStops);
                        if (val == CAN_NOT_UNWRAP) {
                            Object object = CAN_NOT_UNWRAP;
                            return object;
                        }
                        Array.set(array, i, val);
                        ++i;
                    }
                }
                finally {
                    recursionStops.remove(model);
                }
                return array;
            }
            return CAN_NOT_UNWRAP;
        }
        if (isChar || hint == CHARACTER_CLASS) {
            String s;
            if (model instanceof TemplateScalarModel && (s = ((TemplateScalarModel)model).getAsString()).length() == 1) {
                return new Character(s.charAt(0));
            }
            return CAN_NOT_UNWRAP;
        }
        if (DATE_CLASS.isAssignableFrom(hint) && model instanceof TemplateDateModel && hint.isInstance(date = ((TemplateDateModel)model).getAsDate())) {
            return date;
        }
        if (model instanceof TemplateNumberModel && hint.isInstance(number = ((TemplateNumberModel)model).getAsNumber())) {
            return number;
        }
        if (model instanceof TemplateDateModel && hint.isInstance(date = ((TemplateDateModel)model).getAsDate())) {
            return date;
        }
        if (model instanceof TemplateScalarModel && hint.isAssignableFrom(STRING_CLASS)) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateBooleanModel && hint.isAssignableFrom(BOOLEAN_CLASS)) {
            return ((TemplateBooleanModel)model).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (model instanceof TemplateHashModel && hint.isAssignableFrom(HASHADAPTER_CLASS)) {
            return new HashAdapter((TemplateHashModel)model, this);
        }
        if (model instanceof TemplateSequenceModel && hint.isAssignableFrom(SEQUENCEADAPTER_CLASS)) {
            return new SequenceAdapter((TemplateSequenceModel)model, this);
        }
        if (model instanceof TemplateCollectionModel && hint.isAssignableFrom(SETADAPTER_CLASS)) {
            return new SetAdapter((TemplateCollectionModel)model, this);
        }
        if (hint.isInstance(model)) {
            return model;
        }
        return CAN_NOT_UNWRAP;
    }

    private static Number convertUnwrappedNumber(Class hint, Number number) {
        if (hint == Integer.TYPE || hint == Integer.class) {
            return number instanceof Integer ? (Integer)number : new Integer(number.intValue());
        }
        if (hint == Long.TYPE || hint == Long.class) {
            return number instanceof Long ? (Long)number : new Long(number.longValue());
        }
        if (hint == Float.TYPE || hint == Float.class) {
            return number instanceof Float ? (Float)number : new Float(number.floatValue());
        }
        if (hint == Double.TYPE || hint == Double.class) {
            return number instanceof Double ? (Double)number : new Double(number.doubleValue());
        }
        if (hint == Byte.TYPE || hint == Byte.class) {
            return number instanceof Byte ? (Byte)number : new Byte(number.byteValue());
        }
        if (hint == Short.TYPE || hint == Short.class) {
            return number instanceof Short ? (Short)number : new Short(number.shortValue());
        }
        if (hint == BigInteger.class) {
            return number instanceof BigInteger ? number : new BigInteger(number.toString());
        }
        if (hint == BigDecimal.class) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            if (number instanceof Long) {
                return new BigDecimal(number.toString());
            }
            return new BigDecimal(number.doubleValue());
        }
        if (hint.isInstance(number)) {
            return number;
        }
        return null;
    }

    TemplateModel invokeMethod(Object object, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, TemplateModelException {
        Object retval = method.invoke(object, args);
        return method.getReturnType() == Void.TYPE ? TemplateModel.NOTHING : this.getOuterIdentity().wrap(retval);
    }

    public TemplateHashModel getStaticModels() {
        return this.staticModels;
    }

    public TemplateHashModel getEnumModels() {
        if (this.enumModels == null) {
            throw new UnsupportedOperationException("Enums not supported on pre-1.5 JRE");
        }
        return this.enumModels;
    }

    public Object newInstance(Class clazz, List arguments) throws TemplateModelException {
        try {
            Object[] objargs;
            this.introspectClass(clazz);
            Map classInfo = (Map)this.classCache.get(clazz);
            Object ctors = classInfo.get(CONSTRUCTORS);
            if (ctors == null) {
                throw new TemplateModelException("Class " + clazz.getName() + " has no public constructors.");
            }
            Constructor ctor = null;
            if (ctors instanceof SimpleMemberModel) {
                SimpleMemberModel smm = (SimpleMemberModel)ctors;
                ctor = (Constructor)smm.getMember();
                objargs = smm.unwrapArguments(arguments, this);
            } else if (ctors instanceof MethodMap) {
                MethodMap methodMap = (MethodMap)ctors;
                MemberAndArguments maa = methodMap.getMemberAndArguments(arguments);
                objargs = maa.getArgs();
                ctor = (Constructor)maa.getMember();
            } else {
                throw new Error();
            }
            return ctor.newInstance(objargs);
        }
        catch (TemplateModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateModelException("Could not create instance of class " + clazz.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void introspectClass(Class clazz) {
        Map map = this.classCache;
        synchronized (map) {
            if (!this.classCache.containsKey(clazz)) {
                this.introspectClassInternal(clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIntrospectionInfo(Class clazz) {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.remove(clazz);
            this.staticModels.removeIntrospectionInfo(clazz);
            if (this.enumModels != null) {
                this.enumModels.removeIntrospectionInfo(clazz);
            }
            this.cachedClassNames.remove(clazz.getName());
            BeansWrapper beansWrapper = this;
            synchronized (beansWrapper) {
                this.modelCache.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectClassInternal(Class clazz) {
        String className = clazz.getName();
        if (this.cachedClassNames.contains(className)) {
            if (logger.isInfoEnabled()) {
                logger.info("Detected a reloaded class [" + className + "]. Clearing BeansWrapper caches.");
            }
            this.classCache.clear();
            this.cachedClassNames = new HashSet();
            BeansWrapper beansWrapper = this;
            synchronized (beansWrapper) {
                this.modelCache.clearCache();
            }
            this.staticModels.clearCache();
            if (this.enumModels != null) {
                this.enumModels.clearCache();
            }
        }
        this.classCache.put(clazz, this.populateClassMap(clazz));
        this.cachedClassNames.add(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getClassKeyMap(Class clazz) {
        Map map;
        Map map2 = this.classCache;
        synchronized (map2) {
            map = (Map)this.classCache.get(clazz);
            if (map == null) {
                this.introspectClassInternal(clazz);
                map = (Map)this.classCache.get(clazz);
            }
        }
        return map;
    }

    int keyCount(Class clazz) {
        Map map = this.getClassKeyMap(clazz);
        int count = map.size();
        if (map.containsKey(CONSTRUCTORS)) {
            --count;
        }
        if (map.containsKey(GENERIC_GET_KEY)) {
            --count;
        }
        if (map.containsKey(ARGTYPES)) {
            --count;
        }
        return count;
    }

    Set keySet(Class clazz) {
        HashSet set = new HashSet(this.getClassKeyMap(clazz).keySet());
        set.remove(CONSTRUCTORS);
        set.remove(GENERIC_GET_KEY);
        set.remove(ARGTYPES);
        return set;
    }

    private Map populateClassMap(Class clazz) {
        Map map = this.populateClassMapWithBeanInfo(clazz);
        try {
            Constructor<?>[] ctors = clazz.getConstructors();
            if (ctors.length == 1) {
                Constructor<?> ctor = ctors[0];
                map.put(CONSTRUCTORS, new SimpleMemberModel(ctor, ctor.getParameterTypes()));
            } else if (ctors.length > 1) {
                MethodMap ctorMap = new MethodMap("<init>", this);
                int i = 0;
                while (i < ctors.length) {
                    ctorMap.addMember(ctors[i]);
                    ++i;
                }
                map.put(CONSTRUCTORS, ctorMap);
            }
        }
        catch (SecurityException e) {
            logger.warn("Canont discover constructors for class " + clazz.getName(), e);
        }
        switch (map.size()) {
            case 0: {
                map = Collections12.EMPTY_MAP;
                break;
            }
            case 1: {
                Map.Entry e = map.entrySet().iterator().next();
                map = Collections12.singletonMap(e.getKey(), e.getValue());
            }
        }
        return map;
    }

    private Map populateClassMapWithBeanInfo(Class clazz) {
        HashMap<Object, Object> classMap = new HashMap<Object, Object>();
        if (this.exposeFields) {
            Field[] fields = clazz.getFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if ((field.getModifiers() & 8) == 0) {
                    classMap.put(field.getName(), field);
                }
                ++i;
            }
        }
        Map accessibleMethods = BeansWrapper.discoverAccessibleMethods(clazz);
        Method genericGet = BeansWrapper.getFirstAccessibleMethod(MethodSignature.GET_STRING_SIGNATURE, accessibleMethods);
        if (genericGet == null) {
            genericGet = BeansWrapper.getFirstAccessibleMethod(MethodSignature.GET_OBJECT_SIGNATURE, accessibleMethods);
        }
        if (genericGet != null) {
            classMap.put(GENERIC_GET_KEY, genericGet);
        }
        if (this.exposureLevel == 3) {
            return classMap;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] pda = beanInfo.getPropertyDescriptors();
            MethodDescriptor[] mda = beanInfo.getMethodDescriptors();
            int i = pda.length - 1;
            while (i >= 0) {
                PropertyDescriptor pd = pda[i];
                if (pd instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                    Method readMethod = ipd.getIndexedReadMethod();
                    Method publicReadMethod = BeansWrapper.getAccessibleMethod(readMethod, accessibleMethods);
                    if (publicReadMethod != null && this.isSafeMethod(publicReadMethod)) {
                        try {
                            if (readMethod != publicReadMethod) {
                                ipd = new IndexedPropertyDescriptor(ipd.getName(), ipd.getReadMethod(), ipd.getWriteMethod(), publicReadMethod, ipd.getIndexedWriteMethod());
                            }
                            classMap.put(ipd.getName(), ipd);
                            BeansWrapper.getArgTypes(classMap).put(publicReadMethod, publicReadMethod.getParameterTypes());
                        }
                        catch (IntrospectionException e) {
                            logger.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " indexed property " + pd.getName() + ", read method " + publicReadMethod + ", write method " + ipd.getIndexedWriteMethod(), e);
                        }
                    }
                } else {
                    Method readMethod = pd.getReadMethod();
                    Method publicReadMethod = BeansWrapper.getAccessibleMethod(readMethod, accessibleMethods);
                    if (publicReadMethod != null && this.isSafeMethod(publicReadMethod)) {
                        try {
                            if (readMethod != publicReadMethod) {
                                pd = new PropertyDescriptor(pd.getName(), publicReadMethod, pd.getWriteMethod());
                                pd.setReadMethod(publicReadMethod);
                            }
                            classMap.put(pd.getName(), pd);
                        }
                        catch (IntrospectionException e) {
                            logger.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " property " + pd.getName() + ", read method " + publicReadMethod + ", write method " + pd.getWriteMethod(), e);
                        }
                    }
                }
                --i;
            }
            if (this.exposureLevel < 2) {
                i = mda.length - 1;
                while (i >= 0) {
                    MethodDescriptor md = mda[i];
                    Method method = md.getMethod();
                    Method publicMethod = BeansWrapper.getAccessibleMethod(method, accessibleMethods);
                    if (publicMethod != null && this.isSafeMethod(publicMethod)) {
                        String name = md.getName();
                        Object previous = classMap.get(name);
                        if (previous instanceof Method) {
                            MethodMap methodMap = new MethodMap(name, this);
                            methodMap.addMember((Method)previous);
                            methodMap.addMember(publicMethod);
                            classMap.put(name, methodMap);
                            BeansWrapper.getArgTypes(classMap).remove(previous);
                        } else if (previous instanceof MethodMap) {
                            ((MethodMap)previous).addMember(publicMethod);
                        } else {
                            classMap.put(name, publicMethod);
                            BeansWrapper.getArgTypes(classMap).put(publicMethod, publicMethod.getParameterTypes());
                        }
                    }
                    --i;
                }
            }
            return classMap;
        }
        catch (IntrospectionException e) {
            logger.warn("Couldn't properly perform introspection for class " + clazz, e);
            return new HashMap();
        }
    }

    private static Map getArgTypes(Map classMap) {
        HashMap argTypes = (HashMap)classMap.get(ARGTYPES);
        if (argTypes == null) {
            argTypes = new HashMap();
            classMap.put(ARGTYPES, argTypes);
        }
        return argTypes;
    }

    static Class[] getArgTypes(Map classMap, AccessibleObject methodOrCtor) {
        return (Class[])((Map)classMap.get(ARGTYPES)).get(methodOrCtor);
    }

    private static Method getFirstAccessibleMethod(MethodSignature sig, Map accessibles) {
        List l = (List)accessibles.get(sig);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return (Method)l.iterator().next();
    }

    private static Method getAccessibleMethod(Method m, Map accessibles) {
        if (m == null) {
            return null;
        }
        MethodSignature sig = new MethodSignature(m);
        List l = (List)accessibles.get(sig);
        if (l == null) {
            return null;
        }
        for (Method am : l) {
            if (am.getReturnType() != m.getReturnType()) continue;
            return am;
        }
        return null;
    }

    boolean isSafeMethod(Method method) {
        return this.exposureLevel < 1 || !UNSAFE_METHODS.contains(method);
    }

    private static Map discoverAccessibleMethods(Class clazz) {
        HashMap map = new HashMap();
        BeansWrapper.discoverAccessibleMethods(clazz, map);
        return map;
    }

    private static void discoverAccessibleMethods(Class clazz, Map map) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methods = clazz.getMethods();
                int i = 0;
                while (i < methods.length) {
                    Method method = methods[i];
                    MethodSignature sig = new MethodSignature(method);
                    LinkedList<Method> methodList = (LinkedList<Method>)map.get(sig);
                    if (methodList == null) {
                        methodList = new LinkedList<Method>();
                        map.put(sig, methodList);
                    }
                    methodList.add(method);
                    ++i;
                }
                return;
            }
            catch (SecurityException e) {
                logger.warn("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.", e);
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            BeansWrapper.discoverAccessibleMethods(interfaces[i], map);
            ++i;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            BeansWrapper.discoverAccessibleMethods(superclass, map);
        }
    }

    private static final Set createUnsafeMethodsSet() {
        Properties props = new Properties();
        InputStream in = BeansWrapper.class.getResourceAsStream("unsafeMethods.txt");
        if (in != null) {
            String string = null;
            try {
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
                HashSet<Method> set = new HashSet<Method>(props.size() * 4 / 3, 0.75f);
                Map primClasses = BeansWrapper.createPrimitiveClassesMap();
                for (String string2 : props.keySet()) {
                    try {
                        set.add(BeansWrapper.parseMethodSpec(string2, primClasses));
                    }
                    catch (ClassNotFoundException e) {
                        if (!DEVELOPMENT) continue;
                        throw e;
                    }
                    catch (NoSuchMethodException e) {
                        if (!DEVELOPMENT) continue;
                        throw e;
                    }
                }
                return set;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load unsafe method " + string + " " + e.getClass().getName() + " " + e.getMessage());
            }
        }
        return Collections.EMPTY_SET;
    }

    private static Method parseMethodSpec(String methodSpec, Map primClasses) throws ClassNotFoundException, NoSuchMethodException {
        int brace = methodSpec.indexOf(40);
        int dot = methodSpec.lastIndexOf(46, brace);
        Class clazz = ClassUtil.forName(methodSpec.substring(0, dot));
        String methodName = methodSpec.substring(dot + 1, brace);
        String argSpec = methodSpec.substring(brace + 1, methodSpec.length() - 1);
        StringTokenizer tok = new StringTokenizer(argSpec, ",");
        int argcount = tok.countTokens();
        Class[] argTypes = new Class[argcount];
        int i = 0;
        while (i < argcount) {
            String argClassName = tok.nextToken();
            argTypes[i] = (Class)primClasses.get(argClassName);
            if (argTypes[i] == null) {
                argTypes[i] = ClassUtil.forName(argClassName);
            }
            ++i;
        }
        return clazz.getMethod(methodName, argTypes);
    }

    private static Map createPrimitiveClassesMap() {
        HashMap<String, Class<Comparable<Boolean>>> map = new HashMap<String, Class<Comparable<Boolean>>>();
        map.put("boolean", Boolean.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("char", Character.TYPE);
        map.put("short", Short.TYPE);
        map.put("int", Integer.TYPE);
        map.put("long", Long.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        return map;
    }

    public static void coerceBigDecimals(AccessibleObject callable, Object[] args) {
        Class[] formalTypes = null;
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            if (arg instanceof BigDecimal) {
                if (formalTypes == null) {
                    if (callable instanceof Method) {
                        formalTypes = ((Method)callable).getParameterTypes();
                    } else if (callable instanceof Constructor) {
                        formalTypes = ((Constructor)callable).getParameterTypes();
                    } else {
                        throw new IllegalArgumentException("Expected method or  constructor; callable is " + callable.getClass().getName());
                    }
                }
                args[i] = BeansWrapper.coerceBigDecimal((BigDecimal)arg, formalTypes[i]);
            }
            ++i;
        }
    }

    public static void coerceBigDecimals(Class[] formalTypes, Object[] args) {
        int typeLen = formalTypes.length;
        int argsLen = args.length;
        int min = Math.min(typeLen, argsLen);
        int i = 0;
        while (i < min) {
            Object arg = args[i];
            if (arg instanceof BigDecimal) {
                args[i] = BeansWrapper.coerceBigDecimal((BigDecimal)arg, formalTypes[i]);
            }
            ++i;
        }
        if (argsLen > typeLen) {
            Class varArgType = formalTypes[typeLen - 1];
            int i2 = typeLen;
            while (i2 < argsLen) {
                Object arg = args[i2];
                if (arg instanceof BigDecimal) {
                    args[i2] = BeansWrapper.coerceBigDecimal((BigDecimal)arg, varArgType);
                }
                ++i2;
            }
        }
    }

    public static Object coerceBigDecimal(BigDecimal bd, Class formalType) {
        if (formalType == Integer.TYPE || formalType == Integer.class) {
            return new Integer(bd.intValue());
        }
        if (formalType == Double.TYPE || formalType == Double.class) {
            return new Double(bd.doubleValue());
        }
        if (formalType == Long.TYPE || formalType == Long.class) {
            return new Long(bd.longValue());
        }
        if (formalType == Float.TYPE || formalType == Float.class) {
            return new Float(bd.floatValue());
        }
        if (formalType == Short.TYPE || formalType == Short.class) {
            return new Short(bd.shortValue());
        }
        if (formalType == Byte.TYPE || formalType == Byte.class) {
            return new Byte(bd.byteValue());
        }
        if (BIGINTEGER_CLASS.isAssignableFrom(formalType)) {
            return bd.toBigInteger();
        }
        return bd;
    }

    private static ClassBasedModelFactory createEnumModels(BeansWrapper wrapper) {
        if (ENUMS_MODEL_CTOR != null) {
            try {
                return (ClassBasedModelFactory)ENUMS_MODEL_CTOR.newInstance(wrapper);
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return null;
    }

    private static Constructor enumsModelCtor() {
        try {
            Class.forName("java.lang.Enum");
            return Class.forName("freemarker.ext.beans.EnumModels").getDeclaredConstructor(BeansWrapper.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class access$2() {
        return STRING_CLASS;
    }

    static /* synthetic */ Class access$3() {
        return OBJECT_CLASS;
    }

    private static final class MethodSignature {
        private static final MethodSignature GET_STRING_SIGNATURE = new MethodSignature("get", new Class[]{BeansWrapper.access$2()});
        private static final MethodSignature GET_OBJECT_SIGNATURE = new MethodSignature("get", new Class[]{BeansWrapper.access$3()});
        private final String name;
        private final Class[] args;

        private MethodSignature(String name, Class[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

