/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.TemplateElement;

final class TrimInstruction
extends TemplateElement {
    final boolean left;
    final boolean right;

    TrimInstruction(boolean left, boolean right) {
        this.left = left;
        this.right = right;
    }

    @Override
    void accept(Environment env) {
    }

    @Override
    public String getCanonicalForm() {
        if (this.left && this.right) {
            return "<#t>";
        }
        if (this.left) {
            return "<#lt>";
        }
        if (this.right) {
            return "<#rt>";
        }
        return "<#nt>";
    }

    @Override
    public String getDescription() {
        String type = "";
        if (!this.right) {
            type = "left ";
        }
        if (!this.left) {
            type = "right ";
        }
        if (!this.left && !this.right) {
            type = "no-";
        }
        return String.valueOf(type) + "trim instruction";
    }

    @Override
    boolean isIgnorable() {
        return true;
    }
}

