/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.StopException;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;

final class StopInstruction
extends TemplateElement {
    private Expression exp;

    StopInstruction(Expression exp) {
        this.exp = exp;
    }

    @Override
    void accept(Environment env) throws TemplateException {
        if (this.exp == null) {
            throw new StopException(env);
        }
        throw new StopException(env, this.exp.getStringValue(env));
    }

    @Override
    public String getCanonicalForm() {
        String expString = this.exp == null ? "" : " " + this.exp.getCanonicalForm();
        return "<#stop" + expString + "/>";
    }

    @Override
    public String getDescription() {
        return "stop [" + this.getStartLocation() + "]";
    }
}

