/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.math.BigDecimal;

abstract class NumericalBuiltins {
    private static final BigDecimal BIG_DECIMAL_ONE = new BigDecimal("1");

    NumericalBuiltins() {
    }

    static abstract class NumberBuiltIn
    extends BuiltIn {
        NumberBuiltIn() {
        }

        @Override
        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            return this.calculateResult(EvaluationUtil.getNumber(model, this.target, env), model);
        }

        abstract TemplateModel calculateResult(Number var1, TemplateModel var2);
    }

    static class byteBI
    extends NumberBuiltIn {
        byteBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Byte) {
                return model;
            }
            return new SimpleNumber(new Byte(num.byteValue()));
        }
    }

    static class cBI
    extends BuiltIn {
        cBI() {
        }

        @Override
        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            Number num = EvaluationUtil.getNumber(model, this.target, env);
            if (num instanceof Integer) {
                return new SimpleScalar(num.toString());
            }
            return new SimpleScalar(env.getCNumberFormat().format(num));
        }
    }

    static class ceilingBI
    extends NumberBuiltIn {
        ceilingBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).divide(BIG_DECIMAL_ONE, 0, 2));
        }
    }

    static class doubleBI
    extends NumberBuiltIn {
        doubleBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Double) {
                return model;
            }
            return new SimpleNumber(num.doubleValue());
        }
    }

    static class floatBI
    extends NumberBuiltIn {
        floatBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Float) {
                return model;
            }
            return new SimpleNumber(num.floatValue());
        }
    }

    static class floorBI
    extends NumberBuiltIn {
        floorBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).divide(BIG_DECIMAL_ONE, 0, 3));
        }
    }

    static class intBI
    extends NumberBuiltIn {
        intBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Integer) {
                return model;
            }
            return new SimpleNumber(num.intValue());
        }
    }

    static class longBI
    extends NumberBuiltIn {
        longBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Long) {
                return model;
            }
            return new SimpleNumber(num.longValue());
        }
    }

    static class roundBI
    extends NumberBuiltIn {
        private static final BigDecimal half = new BigDecimal("0.5");

        roundBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).add(half).divide(BIG_DECIMAL_ONE, 0, 3));
        }
    }

    static class shortBI
    extends NumberBuiltIn {
        shortBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Short) {
                return model;
            }
            return new SimpleNumber(new Short(num.shortValue()));
        }
    }
}

