/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

final class NumberLiteral
extends Expression
implements TemplateNumberModel {
    private final Number value;

    public NumberLiteral(Number value) {
        this.value = value;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        return new SimpleNumber(this.value);
    }

    @Override
    public String getStringValue(Environment env) {
        return env.formatNumber(this.value);
    }

    @Override
    public Number getAsNumber() {
        return this.value;
    }

    String getName() {
        return "the number: '" + this.value + "'";
    }

    @Override
    public String getCanonicalForm() {
        return this.value.toString();
    }

    @Override
    boolean isLiteral() {
        return true;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new NumberLiteral(this.value);
    }
}

