/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.ClassUtil;
import java.util.List;

class NewBI
extends BuiltIn {
    static final Class TM_CLASS = TemplateModel.class;
    static final Class BEAN_MODEL_CLASS = BeanModel.class;
    static Class JYTHON_MODEL_CLASS;

    static {
        try {
            JYTHON_MODEL_CLASS = Class.forName("freemarker.ext.jython.JythonModel");
        }
        catch (Throwable throwable) {
            JYTHON_MODEL_CLASS = null;
        }
    }

    NewBI() {
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel tm = this.target.getAsTemplateModel(env);
        String classname = null;
        try {
            classname = ((TemplateScalarModel)tm).getAsString();
        }
        catch (ClassCastException classCastException) {
            NewBI.invalidTypeException(tm, this.target, env, "string");
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidReferenceException(String.valueOf(this.getStartLocation()) + "\nCould not resolve expression: " + this.target, env);
        }
        return new ConstructorFunction(classname, env);
    }

    static class ConstructorFunction
    implements TemplateMethodModelEx {
        private final Class cl;
        private final Environment env;

        public ConstructorFunction(String classname, Environment env) throws TemplateException {
            this.env = env;
            try {
                this.cl = ClassUtil.forName(classname);
                if (!TM_CLASS.isAssignableFrom(this.cl)) {
                    throw new TemplateException("Class " + this.cl.getName() + " does not implement freemarker.template.TemplateModel", env);
                }
                if (BEAN_MODEL_CLASS.isAssignableFrom(this.cl)) {
                    throw new TemplateException("Bean Models cannot be instantiated using the ?new built-in", env);
                }
                if (JYTHON_MODEL_CLASS != null && JYTHON_MODEL_CLASS.isAssignableFrom(this.cl)) {
                    throw new TemplateException("Jython Models cannot be instantiated using the ?new built-in", env);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new TemplateException(cnfe, env);
            }
        }

        @Override
        public Object exec(List arguments) throws TemplateModelException {
            ObjectWrapper ow = this.env.getObjectWrapper();
            BeansWrapper bw = ow instanceof BeansWrapper ? (BeansWrapper)ow : BeansWrapper.getDefaultInstance();
            return bw.newInstance(this.cl, arguments);
        }
    }
}

