/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ConditionalBlock;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;

final class IfBlock
extends TemplateElement {
    IfBlock(ConditionalBlock block) {
        this.nestedElements = new ArrayList();
        this.addBlock(block);
    }

    void addBlock(ConditionalBlock block) {
        this.nestedElements.add(block);
    }

    @Override
    void accept(Environment env) throws TemplateException, IOException {
        int i = 0;
        while (i < this.nestedElements.size()) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
            Expression condition = cblock.condition;
            if (condition == null || condition.isTrue(env)) {
                if (cblock.nestedBlock != null) {
                    env.visit(cblock.nestedBlock);
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.nestedElements.size()) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
            buf.append(cblock.getCanonicalForm());
            ++i;
        }
        buf.append("</#if>");
        return buf.toString();
    }

    @Override
    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        if (this.nestedElements.size() == 1) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(0);
            cblock.isSimple = true;
            cblock.setLocation(this.getTemplate(), (TemplateObject)cblock, (TemplateObject)this);
            return cblock.postParseCleanup(stripWhitespace);
        }
        return super.postParseCleanup(stripWhitespace);
    }

    @Override
    public String getDescription() {
        return "if-else ";
    }
}

