/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

final class HashLiteral
extends Expression {
    private final ArrayList keys;
    private final ArrayList values;
    private final int size;

    HashLiteral(ArrayList keys, ArrayList values) {
        this.keys = keys;
        this.values = values;
        this.size = keys.size();
        keys.trimToSize();
        values.trimToSize();
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        return new SequenceHash(env);
    }

    @Override
    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("{");
        int i = 0;
        while (i < this.size) {
            Expression key = (Expression)this.keys.get(i);
            Expression value = (Expression)this.values.get(i);
            buf.append(key.getCanonicalForm());
            buf.append(" : ");
            buf.append(value.getCanonicalForm());
            if (i != this.size - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        int i = 0;
        while (i < this.size) {
            Expression key = (Expression)this.keys.get(i);
            Expression value = (Expression)this.values.get(i);
            if (!key.isLiteral() || !value.isLiteral()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        ArrayList clonedKeys = (ArrayList)this.keys.clone();
        ListIterator<Expression> iter = clonedKeys.listIterator();
        while (iter.hasNext()) {
            iter.set(((Expression)iter.next()).deepClone(name, subst));
        }
        ArrayList clonedValues = (ArrayList)this.values.clone();
        ListIterator<Expression> iter2 = clonedValues.listIterator();
        while (iter2.hasNext()) {
            iter2.set(((Expression)iter2.next()).deepClone(name, subst));
        }
        return new HashLiteral(clonedKeys, clonedValues);
    }

    private class SequenceHash
    implements TemplateHashModelEx {
        private HashMap keyMap = new HashMap();
        private TemplateCollectionModel keyCollection;
        private TemplateCollectionModel valueCollection;

        SequenceHash(Environment env) throws TemplateException {
            ArrayList<String> keyList = new ArrayList<String>(HashLiteral.this.size);
            ArrayList<TemplateModel> valueList = new ArrayList<TemplateModel>(HashLiteral.this.size);
            int i = 0;
            while (i < HashLiteral.this.size) {
                Expression keyExp = (Expression)HashLiteral.this.keys.get(i);
                Expression valExp = (Expression)HashLiteral.this.values.get(i);
                String key = keyExp.getStringValue(env);
                TemplateModel value = valExp.getAsTemplateModel(env);
                HashLiteral.assertNonNull(value, valExp, env);
                this.keyMap.put(key, value);
                keyList.add(key);
                valueList.add(value);
                ++i;
            }
            this.keyCollection = new CollectionAndSequence(new SimpleSequence(keyList));
            this.valueCollection = new CollectionAndSequence(new SimpleSequence(valueList));
        }

        @Override
        public int size() {
            return HashLiteral.this.size;
        }

        @Override
        public TemplateCollectionModel keys() {
            return this.keyCollection;
        }

        @Override
        public TemplateCollectionModel values() {
            return this.valueCollection;
        }

        @Override
        public TemplateModel get(String key) {
            return (TemplateModel)this.keyMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return HashLiteral.this.size == 0;
        }
    }
}

