/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.utility.StandardCompress;
import java.io.IOException;

final class CompressedBlock
extends TemplateElement {
    CompressedBlock(TemplateElement nestedBlock) {
        this.nestedBlock = nestedBlock;
    }

    @Override
    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visit(this.nestedBlock, StandardCompress.INSTANCE, null);
        }
    }

    @Override
    public String getCanonicalForm() {
        String nested = this.nestedBlock != null ? this.nestedBlock.getCanonicalForm() : "";
        return "<#compress>" + nested + "</#compress>";
    }

    @Override
    public String getDescription() {
        return "compressed block";
    }

    @Override
    boolean isIgnorable() {
        return this.nestedBlock == null || this.nestedBlock.isIgnorable();
    }
}

