/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;

final class BooleanLiteral
extends Expression {
    private final boolean val;

    public BooleanLiteral(boolean val) {
        this.val = val;
    }

    static TemplateBooleanModel getTemplateModel(boolean b) {
        return b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }

    @Override
    boolean isTrue(Environment env) {
        return this.val;
    }

    @Override
    public String getCanonicalForm() {
        return this.val ? "true" : "false";
    }

    @Override
    public String toString() {
        return this.val ? "true" : "false";
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        return this.val ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }

    @Override
    boolean isLiteral() {
        return true;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new BooleanLiteral(this.val);
    }
}

