/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.LocalContext;
import freemarker.core.Macro;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class BodyInstruction
extends TemplateElement {
    private List bodyParameters;

    BodyInstruction(List bodyParameters) {
        this.bodyParameters = bodyParameters;
    }

    List getBodyParameters() {
        return this.bodyParameters;
    }

    @Override
    void accept(Environment env) throws IOException, TemplateException {
        Context bodyContext = new Context(env);
        env.visit(bodyContext);
    }

    @Override
    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#nested");
        if (this.bodyParameters != null) {
            int i = 0;
            while (i < this.bodyParameters.size()) {
                buf.append(' ');
                buf.append(this.bodyParameters.get(i));
                ++i;
            }
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public String getDescription() {
        return "nested macro content";
    }

    class Context
    implements LocalContext {
        Macro.Context invokingMacroContext;
        Environment.Namespace bodyVars;

        Context(Environment env) throws TemplateException {
            this.invokingMacroContext = env.getCurrentMacroContext();
            List bodyParameterNames = this.invokingMacroContext.bodyParameterNames;
            if (BodyInstruction.this.bodyParameters != null) {
                int i = 0;
                while (i < BodyInstruction.this.bodyParameters.size()) {
                    Expression exp = (Expression)BodyInstruction.this.bodyParameters.get(i);
                    TemplateModel tm = exp.getAsTemplateModel(env);
                    if (bodyParameterNames != null && i < bodyParameterNames.size()) {
                        String bodyParameterName = (String)bodyParameterNames.get(i);
                        if (this.bodyVars == null) {
                            this.bodyVars = new Environment.Namespace(env);
                        }
                        this.bodyVars.put(bodyParameterName, tm);
                    }
                    ++i;
                }
            }
        }

        @Override
        public TemplateModel getLocalVariable(String name) throws TemplateModelException {
            return this.bodyVars == null ? null : this.bodyVars.get(name);
        }

        @Override
        public Collection getLocalVariableNames() {
            List bodyParameterNames = this.invokingMacroContext.bodyParameterNames;
            return bodyParameterNames == null ? Collections.EMPTY_LIST : bodyParameterNames;
        }
    }
}

