/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BooleanExpression;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.template.TemplateException;

final class AndExpression
extends BooleanExpression {
    private final Expression left;
    private final Expression right;

    AndExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    boolean isTrue(Environment env) throws TemplateException {
        return this.left.isTrue(env) && this.right.isTrue(env);
    }

    @Override
    public String getCanonicalForm() {
        return String.valueOf(this.left.getCanonicalForm()) + " && " + this.right.getCanonicalForm();
    }

    @Override
    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new AndExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }
}

