/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;

class ConcurrentMapFactory {
    private static final Class mapClass = ConcurrentMapFactory.getMapClass();
    private static final Class hashMapClass = ConcurrentMapFactory.getHashMapClass();

    ConcurrentMapFactory() {
    }

    static Map createMap() {
        try {
            return (Map)hashMapClass.newInstance();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    static boolean isConcurrent(Map map) {
        return mapClass != null && mapClass.isInstance(map);
    }

    private static Class getMapClass() {
        try {
            return ClassUtil.forName("java.util.concurrent.ConcurrentMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class getHashMapClass() {
        try {
            return ClassUtil.forName("java.util.concurrent.ConcurrentHashMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return HashMap.class;
        }
    }
}

