/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.modifiers;

import java.util.Arrays;
import java.util.List;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;

public class Enumeration<T> {
    private final List<EnumeratedValue<T>> values;

    public static <T> Enumeration<T> make(List<EnumeratedValue<T>> values) {
        return new Enumeration<T>(values);
    }

    public static <T> Enumeration<T> make(EnumeratedValue<T> ... values) {
        return new Enumeration<T>(Arrays.asList(values));
    }

    public Enumeration(List<EnumeratedValue<T>> values) {
        this.values = values;
    }

    public List<EnumeratedValue<T>> values() {
        return this.values;
    }

    public boolean contains(EnumeratedValue<T> value) {
        return this.values.contains(value);
    }

    public int indexOf(EnumeratedValue<T> value) {
        return this.values.indexOf(value);
    }

    public int size() {
        return this.values.size();
    }

    public EnumeratedValue<T> get(T object) {
        if (object == null) {
            throw new NullPointerException("null object");
        }
        for (EnumeratedValue<T> value : this.values) {
            if (!object.equals(value.getObject())) continue;
            return value;
        }
        throw new IllegalArgumentException("object '" + object + "' not found among enumeration " + this.values);
    }

    public EnumeratedValue<T> findByName(String name) {
        if (name == null) {
            return null;
        }
        for (EnumeratedValue<T> value : this.values) {
            if (!name.equals(value.getName())) continue;
            return value;
        }
        return null;
    }

    public EnumeratedValue<T> findByNameStartsWith(String name) {
        if (name == null) {
            return null;
        }
        for (EnumeratedValue<T> value : this.values) {
            if (!value.getName().startsWith(name)) continue;
            return value;
        }
        return null;
    }

    public EnumeratedValue<T> find(T object) {
        if (object == null) {
            return null;
        }
        for (EnumeratedValue<T> value : this.values) {
            if (!object.equals(value.getObject())) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return this.values.toString();
    }
}

