/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;

public final class NodeContextUtil {
    public static <T> T getInput(NodeContext context, Class<T> clazz) throws ClassCastException {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o == null) {
            throw new NullPointerException("null input");
        }
        return (T)o;
    }

    public static <T> NodeContext withConstant(NodeContext context, NodeContext.ConstantKey<T> key, T value) {
        Set keys = context.getKeys();
        Object[] keyValuePairs = new Object[2 + 2 * keys.size()];
        int index = 0;
        keyValuePairs[index++] = key;
        keyValuePairs[index++] = value;
        for (NodeContext.ConstantKey k : keys) {
            keyValuePairs[index++] = k;
            keyValuePairs[index++] = context.getConstant(k);
        }
        return NodeContextBuilder.buildWithData(keyValuePairs);
    }

    public static <T> T tryGetInput(NodeContext context, Class<T> clazz) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    public static NodeContext[] toContextsWithInput(Collection<?> children) {
        NodeContext[] resultContexts = new NodeContext[children.size()];
        int index = 0;
        for (Object child : children) {
            if (child == null) {
                throw new NullPointerException("Null data.");
            }
            resultContexts[index++] = NodeContextBuilder.buildWithInput(child);
        }
        return resultContexts;
    }

    public static Collection<NodeContext> toContextCollectionWithInput(Object source, Collection<?> children) {
        if (children == null) {
            throw new NullPointerException("Null data (from " + source.getClass().getName() + ").");
        }
        ArrayList<NodeContext> resultContexts = new ArrayList<NodeContext>(children.size());
        for (Object child : children) {
            if (child == null) {
                throw new NullPointerException("Null data (from " + source.getClass().getName() + ").");
            }
            resultContexts.add(NodeContextBuilder.buildWithInput(child));
        }
        return resultContexts;
    }

    public static Collection<NodeContext> toContextCollectionWithInput(Object ... children) {
        ArrayList<NodeContext> resultContexts = new ArrayList<NodeContext>(children.length);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child == null) {
                throw new NullPointerException("Null data.");
            }
            resultContexts.add(NodeContextBuilder.buildWithInput(child));
            ++n2;
        }
        return resultContexts;
    }

    public static NodeContext[] toContextsWithInput(Object ... inputs) {
        NodeContext[] resultContexts = new NodeContext[inputs.length];
        int index = 0;
        Object[] objectArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child == null) {
                throw new NullPointerException("Null data.");
            }
            resultContexts[index++] = NodeContextBuilder.buildWithInput(child);
            ++n2;
        }
        return resultContexts;
    }

    public static NodeContext[] toContexts(Collection<?> children, NodeContextFactory factory) {
        NodeContext[] resultContexts = new NodeContext[children.size()];
        int index = 0;
        for (Object child : children) {
            if (child == null) {
                throw new NullPointerException("Null data.");
            }
            resultContexts[index++] = factory.create(child);
        }
        return resultContexts;
    }

    public static interface NodeContextFactory {
        public NodeContext create(Object var1);
    }
}

