/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.utils.LogContentBean;
import org.simantics.datatypes.utils.LogContentBinding;
import org.simantics.datatypes.utils.LogContentManager;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public final class LogUtils
implements LogContentManager {
    public static final boolean DEBUG = false;
    public final Binding CONTENT_BEAN_BINDING;
    public final DatatypeResource DATA;

    public LogUtils(ReadGraph graph) throws DatabaseException {
        try {
            this.CONTENT_BEAN_BINDING = new LogContentBinding((SerialisationSupport)graph.getService(SerialisationSupport.class));
            this.DATA = DatatypeResource.getInstance((ReadGraph)graph);
        }
        catch (RuntimeBindingConstructionException e) {
            Logger.defaultLogError((Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
    }

    public Resource create(WriteGraph graph, int t, int stamp) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource tree = graph.newResource();
        graph.claim(tree, L0.InstanceOf, null, this.DATA.Log);
        Resource index = this.createIndexNode(graph, this, stamp, t);
        graph.claim(tree, this.DATA.Log_root, this.DATA.Log_root_Inverse, index);
        graph.claimLiteral(tree, this.DATA.Log_t, (Object)t, (Binding)Bindings.INTEGER);
        Resource leaf = this.createLeafNode(graph, this, stamp, t);
        graph.claim(index, this.DATA.BtreeNode_Content, null, leaf);
        LogContentBean rContent = this.getContentBean((ReadGraph)graph, index);
        rContent.n = 1;
        rContent.stamps[0] = stamp;
        rContent.resources[0].r = leaf;
        this.setContentBean(graph, index, rContent);
        return tree;
    }

    public void insert(WriteGraph graph, Resource T, int stamp, Resource v) throws DatabaseException {
        Resource r = this.getRoot((ReadGraph)graph, T);
        int t = this.getDegree((ReadGraph)graph, T);
        this.insertImpl(graph, this, T, r, t, stamp, v);
    }

    public void insertAll(WriteGraph graph, Resource T, Collection<Pair<Integer, Resource>> values) throws DatabaseException {
        Resource r = this.getRoot((ReadGraph)graph, T);
        int t = this.getDegree((ReadGraph)graph, T);
        BatchContentManager cm = new BatchContentManager(this);
        for (Pair<Integer, Resource> entry : values) {
            this.insertImpl(graph, cm, T, r, t, (Integer)entry.first, (Resource)entry.second);
        }
        cm.apply(graph);
    }

    private void insertImpl(WriteGraph graph, LogContentManager manager, Resource T, Resource r, int t, int k, Resource v) throws DatabaseException {
        int code = this.insertImpl2(graph, manager, 0, T, r, t, k, v);
        if (code > 0) {
            LogContentBean rContent = manager.getContentBean((ReadGraph)graph, r);
            Resource newRoot = this.createIndexNode(graph, manager, k, t);
            graph.claim(newRoot, this.DATA.Log_Node_Contains, null, r);
            this.setRoot(graph, T, newRoot);
            LogContentBean nContent = manager.getContentBean((ReadGraph)graph, newRoot);
            nContent.stamps[0] = rContent.stamps[0];
            nContent.resources[0].r = r;
            nContent.n = 1;
            manager.setContentBean(graph, newRoot, nContent);
            Resource leaf = this.createLeaf(graph, manager, newRoot, code, k, t);
            LogContentBean lContent = manager.getContentBean((ReadGraph)graph, leaf);
            lContent.n = 1;
            lContent.stamps[0] = k;
            lContent.resources[0].r = v;
            manager.setContentBean(graph, leaf, lContent);
        }
    }

    private int insertImpl2(WriteGraph graph, LogContentManager manager, int level, Resource T, Resource r, int t, int k, Resource v) throws DatabaseException {
        LogContentBean rContent = manager.getContentBean((ReadGraph)graph, r);
        if (!rContent.leaf) {
            Resource child = rContent.resources[rContent.n - 1].r;
            int code = this.insertImpl2(graph, manager, level + 1, T, child, t, k, v);
            if (code == 0) {
                return 0;
            }
            if (rContent.n < t) {
                Resource leaf = this.createLeaf(graph, manager, r, code - level - 1, k, t);
                LogContentBean lContent = manager.getContentBean((ReadGraph)graph, leaf);
                lContent.stamps[0] = k;
                lContent.resources[0].r = v;
                lContent.n = 1;
                manager.setContentBean(graph, leaf, lContent);
                return 0;
            }
            return code;
        }
        if (rContent.n < t) {
            rContent.stamps[rContent.n] = k;
            rContent.resources[rContent.n].r = v;
            ++rContent.n;
            manager.setContentBean(graph, r, rContent);
            return 0;
        }
        return level;
    }

    private Resource createLeaf(WriteGraph graph, LogContentManager manager, Resource r, int code, int stamp, int t) throws DatabaseException {
        LogContentBean rContent = manager.getContentBean((ReadGraph)graph, r);
        if (code == 0) {
            Resource result = this.createLeafNode(graph, manager, stamp, t);
            graph.claim(r, this.DATA.Log_Node_Contains, null, result);
            rContent.stamps[rContent.n] = stamp;
            rContent.resources[rContent.n].r = result;
            ++rContent.n;
            manager.setContentBean(graph, r, rContent);
            return result;
        }
        Resource index = this.createIndexNode(graph, manager, stamp, t);
        graph.claim(r, this.DATA.Log_Node_Contains, null, index);
        rContent.stamps[rContent.n] = stamp;
        rContent.resources[rContent.n].r = index;
        ++rContent.n;
        manager.setContentBean(graph, r, rContent);
        return this.createLeaf(graph, manager, index, code - 1, stamp, t);
    }

    private Resource createIndexNode(WriteGraph graph, LogContentManager manager, int stamp, int t) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        graph.claim(result, L0.InstanceOf, null, this.DATA.Log_IndexNode);
        manager.setContentBean(graph, result, LogContentBean.create(t, stamp, false));
        return result;
    }

    private Resource createLeafNode(WriteGraph graph, LogContentManager manager, int stamp, int t) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        graph.claim(result, L0.InstanceOf, null, this.DATA.Log_LeafNode);
        manager.setContentBean(graph, result, LogContentBean.create(t, stamp, true));
        return result;
    }

    private Resource getRoot(ReadGraph graph, Resource T) throws DatabaseException {
        return graph.getPossibleObject(T, this.DATA.Log_root);
    }

    private void setRoot(WriteGraph graph, Resource T, Resource r) throws DatabaseException {
        graph.deny(T, this.DATA.Log_root);
        graph.claim(T, this.DATA.Log_root, r);
    }

    @Override
    public void setContentBean(WriteGraph graph, Resource node, LogContentBean bean) throws DatabaseException {
        graph.claimLiteral(node, this.DATA.Log_Node_content, this.DATA.Log_Content, (Object)bean, this.CONTENT_BEAN_BINDING);
    }

    private int getDegree(ReadGraph graph, Resource tree) throws DatabaseException {
        return (Integer)graph.syncRequest((AsyncRead)new RelatedValue(tree, this.DATA.Log_t, (Binding)Bindings.INTEGER), (Listener)TransientCacheListener.instance());
    }

    @Override
    public LogContentBean getContentBean(ReadGraph graph, Resource node) throws DatabaseException {
        return (LogContentBean)((Object)graph.syncRequest((AsyncRead)new RelatedValue(node, this.DATA.Log_Node_content, this.CONTENT_BEAN_BINDING), (Listener)TransientCacheListener.instance()));
    }

    static class BatchContentManager
    implements LogContentManager {
        private final LogUtils bu;
        final Map<Resource, LogContentBean> beans = new HashMap<Resource, LogContentBean>();

        public BatchContentManager(LogUtils bu) {
            this.bu = bu;
        }

        @Override
        public LogContentBean getContentBean(ReadGraph graph, Resource node) throws DatabaseException {
            LogContentBean bean = this.beans.get(node);
            if (bean != null) {
                return bean;
            }
            return this.bu.getContentBean(graph, node);
        }

        @Override
        public void setContentBean(WriteGraph graph, Resource node, LogContentBean bean) throws DatabaseException {
            this.beans.put(node, bean);
        }

        public void apply(WriteGraph graph) throws DatabaseException {
            for (Map.Entry<Resource, LogContentBean> entry : this.beans.entrySet()) {
                this.bu.setContentBean(graph, entry.getKey(), entry.getValue());
            }
        }
    }
}

