/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.utils.BtreeContentBean;
import org.simantics.datatypes.utils.BtreeContentManager;
import org.simantics.datatypes.utils.LogContentBinding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public final class BtreeUtils
implements BtreeContentManager {
    public final Binding CONTENT_BEAN_BINDING;
    public final DatatypeResource DATA;

    public BtreeUtils(ReadGraph graph) throws DatabaseException {
        try {
            this.CONTENT_BEAN_BINDING = new LogContentBinding((SerialisationSupport)graph.getService(SerialisationSupport.class));
            this.DATA = DatatypeResource.getInstance((ReadGraph)graph);
        }
        catch (RuntimeBindingConstructionException e) {
            Logger.defaultLogError((Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
    }

    public Resource create(WriteGraph graph, int t) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource tree = graph.newResource();
        graph.claim(tree, L0.InstanceOf, null, this.DATA.Btree);
        Resource node = this.createNode(graph, this, this.DATA.BtreeNode, t);
        graph.claim(tree, this.DATA.Btree_root, this.DATA.Btree_root_Inverse, node);
        graph.claimLiteral(tree, this.DATA.Btree_t, (Object)t, (Binding)Bindings.INTEGER);
        return tree;
    }

    public void insert(WriteGraph graph, Resource T, int k, Resource v) throws DatabaseException {
        Resource r = this.getRoot((ReadGraph)graph, T);
        int t = this.getDegree((ReadGraph)graph, T);
        this.insertImpl(graph, this, T, r, t, k, v);
    }

    public void insertAll(WriteGraph graph, Resource T, Collection<Pair<Integer, Resource>> values) throws DatabaseException {
        Resource r = this.getRoot((ReadGraph)graph, T);
        int t = this.getDegree((ReadGraph)graph, T);
        BatchContentManager cm = new BatchContentManager(this);
        for (Pair<Integer, Resource> entry : values) {
            this.insertImpl(graph, cm, T, r, t, (Integer)entry.first, (Resource)entry.second);
        }
        cm.apply(graph);
    }

    public Resource search(ReadGraph graph, Resource tree, long k) throws DatabaseException {
        DatatypeResource DATA = DatatypeResource.getInstance((ReadGraph)graph);
        Resource r = this.getRoot(graph, tree);
        int t = (Integer)graph.getRelatedValue(tree, DATA.Btree_t, (Binding)Bindings.INTEGER);
        return this.searchNode(graph, t, r, k);
    }

    private void insertImpl(WriteGraph graph, BtreeContentManager manager, Resource T, Resource r, int t, int k, Resource v) throws DatabaseException {
        BtreeContentBean rContent = manager.getContentBean((ReadGraph)graph, r);
        if (rContent.n == 2 * t - 1) {
            Resource s = this.allocateNode(graph, manager, t);
            BtreeContentBean sContent = manager.getContentBean((ReadGraph)graph, s);
            this.setRoot(graph, T, s);
            sContent.leaf = false;
            sContent.n = 0;
            sContent.c[0].r = r;
            manager.setContentBean(graph, s, sContent);
            this.splitChild(graph, manager, t, s, 1, r);
            this.insertNonfull(graph, manager, t, s, k, v);
        } else {
            this.insertNonfull(graph, manager, t, r, k, v);
        }
    }

    private Resource createNode(WriteGraph graph, BtreeContentManager manager, Resource type, int t) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        graph.claim(result, L0.InstanceOf, null, type);
        manager.setContentBean(graph, result, BtreeContentBean.create(t));
        return result;
    }

    private Resource searchNode(ReadGraph graph, int t, Resource x, long k) throws DatabaseException {
        BtreeContentBean xContent = this.getContentBean(graph, x);
        int i = 1;
        while (i <= xContent.n && k > xContent.key[i - 1]) {
            ++i;
        }
        if (i <= xContent.n && k == xContent.key[i - 1]) {
            return xContent.value[i - 1].r;
        }
        if (xContent.leaf) {
            return null;
        }
        return this.searchNode(graph, t, xContent.c[i - 1].r, k);
    }

    private void splitChild(WriteGraph graph, BtreeContentManager manager, int t, Resource x, int i, Resource y) throws DatabaseException {
        Resource z = this.allocateNode(graph, manager, t);
        BtreeContentBean xContent = manager.getContentBean((ReadGraph)graph, x);
        BtreeContentBean yContent = manager.getContentBean((ReadGraph)graph, y);
        BtreeContentBean zContent = manager.getContentBean((ReadGraph)graph, z);
        zContent.leaf = yContent.leaf;
        zContent.n = t - 1;
        int j = 1;
        while (j <= t - 1) {
            zContent.key[j - 1] = yContent.key[j + t - 1];
            zContent.value[j - 1] = yContent.value[j + t - 1];
            ++j;
        }
        if (!yContent.leaf) {
            j = 1;
            while (j <= t) {
                zContent.c[j - 1] = yContent.c[j + t - 1];
                ++j;
            }
        }
        yContent.n = t - 1;
        j = xContent.n + 1;
        while (j >= i + 1) {
            xContent.c[j + 1 - 1] = xContent.c[j - 1];
            --j;
        }
        xContent.c[i + 1 - 1].r = z;
        j = xContent.n;
        while (j >= i) {
            xContent.key[j + 1 - 1] = xContent.key[j - 1];
            xContent.value[j + 1 - 1] = xContent.value[j - 1];
            --j;
        }
        xContent.key[i - 1] = yContent.key[t - 1];
        xContent.value[i - 1] = yContent.value[t - 1];
        ++xContent.n;
        manager.setContentBean(graph, x, xContent);
        manager.setContentBean(graph, y, yContent);
        manager.setContentBean(graph, z, zContent);
    }

    /*
     * Unable to fully structure code
     */
    private void insertNonfull(WriteGraph graph, BtreeContentManager manager, int t, Resource x, long k, Resource v) throws DatabaseException {
        block4: {
            xContent = manager.getContentBean((ReadGraph)graph, x);
            i = xContent.n;
            if (!xContent.leaf) ** GOTO lbl15
            while (i >= 1 && k < xContent.key[i - 1]) {
                xContent.key[i + 1 - 1] = xContent.key[i - 1];
                xContent.value[i + 1 - 1] = xContent.value[i - 1];
                --i;
            }
            xContent.key[i + 1 - 1] = k;
            xContent.value[i + 1 - 1].r = v;
            ++xContent.n;
            manager.setContentBean(graph, x, xContent);
            break block4;
lbl-1000:
            // 1 sources

            {
                --i;
lbl15:
                // 2 sources

                ** while (i >= 1 && k < xContent.key[i - 1])
            }
lbl16:
            // 1 sources

            xciContent = manager.getContentBean((ReadGraph)graph, xContent.c[++i - 1].r);
            if (xciContent.n == 2 * t - 1) {
                this.splitChild(graph, manager, t, x, i, xContent.c[i - 1].r);
                xContent = manager.getContentBean((ReadGraph)graph, x);
                if (k > xContent.key[i - 1]) {
                    ++i;
                }
            }
            this.insertNonfull(graph, manager, t, xContent.c[i - 1].r, k, v);
        }
    }

    private Resource getRoot(ReadGraph graph, Resource T) throws DatabaseException {
        return graph.getPossibleObject(T, this.DATA.Btree_root);
    }

    private void setRoot(WriteGraph graph, Resource T, Resource r) throws DatabaseException {
        graph.deny(T, this.DATA.Btree_root);
        graph.claim(T, this.DATA.Btree_root, r);
    }

    private Resource allocateNode(WriteGraph graph, BtreeContentManager manager, int t) throws DatabaseException {
        return this.createNode(graph, manager, this.DATA.BtreeNode, t);
    }

    @Override
    public void setContentBean(WriteGraph graph, Resource node, BtreeContentBean bean) throws DatabaseException {
        graph.claimLiteral(node, this.DATA.BtreeNode_content, this.DATA.BtreeNode_Content, (Object)bean, this.CONTENT_BEAN_BINDING);
    }

    private int getDegree(ReadGraph graph, Resource tree) throws DatabaseException {
        return (Integer)graph.syncRequest((AsyncRead)new RelatedValue(tree, this.DATA.Btree_t, (Binding)Bindings.INTEGER), (Listener)TransientCacheListener.instance());
    }

    @Override
    public BtreeContentBean getContentBean(ReadGraph graph, Resource node) throws DatabaseException {
        return (BtreeContentBean)((Object)graph.syncRequest((AsyncRead)new RelatedValue(node, this.DATA.BtreeNode_content, this.CONTENT_BEAN_BINDING), (Listener)TransientCacheListener.instance()));
    }

    static class BatchContentManager
    implements BtreeContentManager {
        private final BtreeUtils bu;
        final Map<Resource, BtreeContentBean> beans = new HashMap<Resource, BtreeContentBean>();

        public BatchContentManager(BtreeUtils bu) {
            this.bu = bu;
        }

        @Override
        public BtreeContentBean getContentBean(ReadGraph graph, Resource node) throws DatabaseException {
            BtreeContentBean bean = this.beans.get(node);
            if (bean != null) {
                return bean;
            }
            return this.bu.getContentBean(graph, node);
        }

        @Override
        public void setContentBean(WriteGraph graph, Resource node, BtreeContentBean bean) throws DatabaseException {
            this.beans.put(node, bean);
        }

        public void apply(WriteGraph graph) throws DatabaseException {
            for (Map.Entry<Resource, BtreeContentBean> entry : this.beans.entrySet()) {
                this.bu.setContentBean(graph, entry.getKey(), entry.getValue());
            }
        }
    }
}

