/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.utils;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.datatypes.utils.BtreeContentBean;
import org.simantics.datatypes.utils.PossibleResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.SerialisationSupport;

class BtreeContentBinding
extends Binding {
    private final SerialisationSupport ss;
    private final Serializer serializer = new Serializer(){

        public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void serialize(DataOutput out, Object obj) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object deserialize(DataInput in, List<Object> identities) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object deserialize(DataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deserializeTo(DataInput in, List<Object> identities, Object dst) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deserializeTo(DataInput in, Object dst) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void skip(DataInput in, List<Object> identities) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void skip(DataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Integer getConstantSize() {
            throw new UnsupportedOperationException();
        }

        public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int getSize(Object obj) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int getMinSize() {
            throw new UnsupportedOperationException();
        }

        public byte[] serialize(Object obj) throws IOException {
            BtreeContentBean bean = (BtreeContentBean)((Object)obj);
            int bytes = 9 + 8 * bean.key.length + 8 * bean.value.length + 8 * bean.c.length;
            byte[] result = new byte[bytes];
            result[0] = bean.leaf ? (byte)1 : 0;
            int byteIndex = 1;
            Bytes.writeLE((byte[])result, (int)byteIndex, (int)bean.n);
            Bytes.writeLE((byte[])result, (int)(byteIndex += 4), (int)((bean.key.length + 1) / 2));
            byteIndex += 4;
            long[] lArray = bean.key;
            int n = bean.key.length;
            int n2 = 0;
            while (n2 < n) {
                long l = lArray[n2];
                Bytes.writeLE((byte[])result, (int)byteIndex, (long)l);
                byteIndex += 8;
                ++n2;
            }
            PossibleResource[] possibleResourceArray = bean.value;
            n2 = bean.value.length;
            int n3 = 0;
            while (n3 < n2) {
                PossibleResource pr = possibleResourceArray[n3];
                Bytes.writeLE((byte[])result, (int)byteIndex, (long)pr.longValue());
                byteIndex += 8;
                ++n3;
            }
            possibleResourceArray = bean.c;
            n2 = bean.c.length;
            n3 = 0;
            while (n3 < n2) {
                PossibleResource pr = possibleResourceArray[n3];
                Bytes.writeLE((byte[])result, (int)byteIndex, (long)pr.longValue());
                byteIndex += 8;
                ++n3;
            }
            return result;
        }

        public Object deserialize(byte[] data) throws IOException {
            BtreeContentBean result = new BtreeContentBean();
            try {
                result.leaf = data[0] == 1;
                int byteIndex = 1;
                result.n = Bytes.readLE4((byte[])data, (int)byteIndex);
                int t = Bytes.readLE4((byte[])data, (int)(byteIndex += 4));
                byteIndex += 4;
                result.key = new long[2 * t - 1];
                result.value = new PossibleResource[2 * t - 1];
                result.c = new PossibleResource[2 * t];
                int i = 0;
                while (i < 2 * t - 1) {
                    result.key[i] = Bytes.readLE8((byte[])data, (int)byteIndex);
                    byteIndex += 8;
                    ++i;
                }
                i = 0;
                while (i < 2 * t - 1) {
                    result.value[i] = PossibleResource.read(BtreeContentBinding.this.ss, Bytes.readLE8((byte[])data, (int)byteIndex));
                    byteIndex += 8;
                    ++i;
                }
                i = 0;
                while (i < 2 * t) {
                    result.c[i] = PossibleResource.read(BtreeContentBinding.this.ss, Bytes.readLE8((byte[])data, (int)byteIndex));
                    byteIndex += 8;
                    ++i;
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            return result;
        }
    };

    public BtreeContentBinding(SerialisationSupport ss) {
        this.ss = ss;
    }

    public void accept(Binding.Visitor1 v, Object obj) {
        throw new UnsupportedOperationException();
    }

    public <T> T accept(Binding.Visitor<T> v) {
        throw new UnsupportedOperationException();
    }

    public boolean isInstance(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        throw new UnsupportedOperationException();
    }

    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public int getComponentCount() {
        throw new UnsupportedOperationException();
    }

    public Binding getComponentBinding(int index) {
        throw new UnsupportedOperationException();
    }

    public Binding getComponentBinding(ChildReference path) {
        throw new UnsupportedOperationException();
    }

    public Serializer serializer() throws RuntimeSerializerConstructionException {
        return this.serializer;
    }
}

