/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl.contribution;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public abstract class FinalImagerContributionImpl
implements Imager {
    private static final Map<String, ImageDescriptor> PENDING = Collections.emptyMap();
    protected final PrimitiveQueryUpdater updater;
    private final ResourceQuery<Map<String, ImageDescriptor>> imagerQuery;
    protected final NodeContext context;
    private final BuiltinKeys.ImagerKey key;
    protected Map<String, ImageDescriptor> content = null;

    public Object getIdentity(BuiltinKeys.ImagerKey key) {
        return key;
    }

    public FinalImagerContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ImagerKey key) {
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.imagerQuery = new ResourceQuery<Map<String, ImageDescriptor>>(this.getIdentity(key), context){

            public Map<String, ImageDescriptor> perform(ReadGraph graph) throws DatabaseException {
                try {
                    return FinalImagerContributionImpl.this.getDescriptors(graph, this.context);
                }
                catch (PendingVariableException e) {
                    return PENDING;
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((String)"LazyGraphLabeler.labelQuery produced unexpected exception.", (Throwable)t);
                    return null;
                }
            }

            public String toString() {
                return FinalImagerContributionImpl.this + " with context " + this.context;
            }
        };
    }

    protected Procedure<Map<String, ImageDescriptor>> createProcedure() {
        return new Procedure<Map<String, ImageDescriptor>>(){

            public void execute(Map<String, ImageDescriptor> result) {
                FinalImagerContributionImpl.this.replaceResult(result);
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((String)"FinalImagerContributionImpl.imagerQuery failed, see exception for details.", (Throwable)t);
            }
        };
    }

    protected void replaceResult(Map<String, ImageDescriptor> desc) {
        this.content = desc;
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    public ImageDescriptor getImage(String key) {
        if (this.content == null) {
            this.content = PENDING;
            DataSource source = this.updater.getDataSource(ReadGraph.class);
            assert (source != null);
            final Procedure<Map<String, ImageDescriptor>> procedure = this.createProcedure();
            source.schedule((Callback)new Callback<ReadGraph>(){

                public void run(ReadGraph source) {
                    if (procedure instanceof Listener) {
                        source.asyncRequest((Read)FinalImagerContributionImpl.this.imagerQuery, (Listener)procedure);
                    } else {
                        source.asyncRequest((Read)FinalImagerContributionImpl.this.imagerQuery, procedure);
                    }
                }
            });
            return null;
        }
        ImageDescriptor descriptor = this.content.get(key);
        return descriptor;
    }

    public abstract Map<String, ImageDescriptor> getDescriptors(ReadGraph var1, NodeContext var2) throws DatabaseException;
}

