/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl.contribution;

import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.graph.impl.contribution.ContributionStub;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public abstract class CallbackViewpointContributionImpl
extends ContributionStub {
    protected final PrimitiveQueryUpdater updater;
    private final NodeContext context;
    private final BuiltinKeys.ViewpointContributionKey key;

    public abstract void children(ReadGraph var1, NodeContext var2, Callback<Collection<?>> var3) throws DatabaseException;

    public CallbackViewpointContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointContributionKey key) {
        assert (updater != null);
        assert (context != null);
        assert (key != null);
        this.updater = updater;
        this.context = context;
        this.key = key;
    }

    public NodeContext getContext() {
        return this.context;
    }

    public Collection<NodeContext> getContribution() {
        DataSource source;
        if (this.children == ViewpointContribution.PENDING_CONTRIBUTION && (source = this.updater.getDataSource(ReadGraph.class)) != null) {
            source.schedule((Callback)new Callback<ReadGraph>(){

                public void run(ReadGraph source) {
                    ReadRequest childQuery = new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            try {
                                CallbackViewpointContributionImpl.this.children(graph, CallbackViewpointContributionImpl.this.context, new Callback<Collection<?>>(){

                                    public void run(Collection<?> source) {
                                        CallbackViewpointContributionImpl.this.replaceChildrenResult(NodeContextUtil.toContextCollectionWithInput((Object)CallbackViewpointContributionImpl.this, source));
                                    }
                                });
                            }
                            catch (DatabaseException e) {
                                throw e;
                            }
                            catch (Throwable t) {
                                ErrorLogger.defaultLogError((String)"LazyContributionImpl.childQuery produced unexpected exception.", (Throwable)t);
                            }
                        }

                        public String toString() {
                            return "LazyContributionImpl[" + System.identityHashCode(CallbackViewpointContributionImpl.this) + "].childQuery";
                        }
                    };
                    source.asyncRequest((Read)childQuery);
                }
            });
        }
        return this.children;
    }

    protected void replaceChildrenResult(Collection<NodeContext> result) {
        this.setChildren(this.updater, result);
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    protected <T> T getInput(Class<T> clazz) throws ClassCastException {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o == null) {
            throw new NullPointerException("null input");
        }
        return (T)o;
    }

    protected <T> T tryGetInput(Class<T> clazz) {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    public Tester getNodeContextTester() {
        return null;
    }
}

