/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;

public class ResourceProperty
implements IProperty {
    protected final IProperty.Type type;
    protected final Resource subject;
    protected final Resource predicate;
    protected final Resource value;
    protected final ResourceArray path;

    public ResourceProperty(IProperty.Type type, Resource subject, Resource predicate, Resource value, ResourceArray path) {
        this.type = type;
        this.subject = subject;
        this.predicate = predicate;
        this.value = value;
        this.path = path;
    }

    public IProperty.Type getType() {
        return this.type;
    }

    public <T> T getData(Class<T> clazz) {
        Object t = this.getAdapter(clazz);
        if (t != null) {
            return (T)t;
        }
        throw new ClassCastException("class " + clazz.getCanonicalName() + " not adaptable from " + this.toString());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[subject=" + this.subject + ", predicate=" + this.predicate + ", value=" + this.value + ", path=" + this.path + "]";
    }

    public Object getAdapter(Class adapter) {
        return this.adapt(adapter);
    }

    public <T> T adapt(Class<T> adapter) {
        if (adapter == ResourceArray[].class) {
            return (T)new ResourceArray[]{new ResourceArray(new Resource[]{this.subject, this.predicate, this.value}), this.path};
        }
        if (adapter == ResourceArray.class) {
            return (T)new ResourceArray(new Resource[]{this.subject, this.predicate, this.value});
        }
        if (adapter == Resource[].class) {
            return (T)new Resource[]{this.subject, this.predicate, this.value};
        }
        if (adapter == Resource.class) {
            return (T)this.value;
        }
        return null;
    }

    public int propertyHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.subject.hashCode();
        result = 31 * result + this.predicate.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean propertyEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceProperty other = (ResourceProperty)obj;
        return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.path.equals((Object)other.path);
    }

    public int hashCode() {
        return this.propertyHashCode() * 31 + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.propertyEquals(obj)) {
            return false;
        }
        ResourceProperty other = (ResourceProperty)obj;
        return this.value.equals(other.value) && this.type.equals((Object)other.type);
    }
}

