/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.browsing.ui.graph.impl.LazyGraphLabeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.ArrayMap;

public class RelationContextLabelerFactory
implements LabelerFactory {
    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, BuiltinKeys.LabelerKey key) {
        assert (updater != null);
        assert (context != null);
        return new LazyGraphLabeler(updater, context, key){

            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                RelationContext ctx = (RelationContext)context.getConstant(BuiltinKeys.INPUT);
                String property = LabelerUtil.safeStringRepresentation(graph, ctx.getStatement().getPredicate());
                String object = (String)graph.getPossibleRelatedAdapter(ctx.getSubject(), ctx.getStatement().getPredicate(), String.class);
                if (object == null) {
                    object = LabelerUtil.safeStringRepresentation(graph, ctx.getStatement().getObject());
                }
                return ArrayMap.make((Object[])ColumnKeys.KEYS_PROPERTY_VALUE, (Object[])new String[]{property, object});
            }
        };
    }
}

