/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.DataSource;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public class ReadGraphDataSource
implements DataSource<ReadGraph> {
    private final AsyncRequestProcessor processor;
    private final LifecycleSupport ls;

    public ReadGraphDataSource(AsyncRequestProcessor processor) {
        this.processor = processor;
        this.ls = (LifecycleSupport)processor.getService(LifecycleSupport.class);
    }

    public void schedule(final Callback<ReadGraph> callback) {
        if (this.ls.isClosing() || this.ls.isClosed()) {
            return;
        }
        this.processor.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) {
                if (ReadGraphDataSource.this.ls.isClosing() || ReadGraphDataSource.this.ls.isClosed()) {
                    return;
                }
                callback.run((Object)graph);
            }
        }, (Procedure)new ProcedureAdapter<Object>(){

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        });
    }

    public Class<ReadGraph> getProvidedClass() {
        return ReadGraph.class;
    }
}

