/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.utils.Container;
import org.simantics.utils.datastructures.Callback;

public abstract class LazyResourceQueryContainer<Result>
implements Container<Result> {
    private final ResourceQuery<Result> query;
    private final PrimitiveQueryUpdater updater;
    private final Listener<Result> procedure;
    protected final NodeContext context;
    private Result result;
    private boolean computed = false;

    protected abstract Result compute(ReadGraph var1) throws DatabaseException;

    protected abstract NodeContext.PrimitiveQueryKey<Container<Result>> getKey();

    public LazyResourceQueryContainer(final PrimitiveQueryUpdater updater, final NodeContext context, Result initial) {
        this.updater = updater;
        this.context = context;
        this.result = initial;
        this.query = new ResourceQuery<Result>(this.getKey(), context){

            public Result perform(ReadGraph graph) throws DatabaseException {
                return LazyResourceQueryContainer.this.compute(graph);
            }
        };
        this.procedure = new Listener<Result>(){

            public void execute(Result result) {
                LazyResourceQueryContainer.this.setResult(result);
                updater.scheduleReplace(context, LazyResourceQueryContainer.this.getKey(), (Object)LazyResourceQueryContainer.this);
            }

            public boolean isDisposed() {
                return updater.isDisposed();
            }

            public void exception(Throwable t) {
                System.out.print("LazyResourceQueryContainer2.request failed: ");
                t.printStackTrace();
            }
        };
    }

    protected PrimitiveQueryUpdater getUpdater() {
        return this.updater;
    }

    private void setResult(Result result) {
        this.result = result;
        this.computed = true;
    }

    public Result get() {
        if (!this.computed) {
            DataSource source = this.updater.getDataSource(ReadGraph.class);
            assert (source != null);
            source.schedule((Callback)new Callback<ReadGraph>(){

                public void run(ReadGraph source) {
                    source.asyncRequest((Read)LazyResourceQueryContainer.this.query, LazyResourceQueryContainer.this.procedure);
                }
            });
        }
        return this.result;
    }
}

