/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.viewpoints.ViewpointStub;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.graph.impl.request.ParametrizedResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;

public abstract class LazyParametrizedViewpoint
extends ViewpointStub {
    private static final Object CHILDREN = new Object();
    private static final Object HAS_CHILDREN = new Object();
    private final ParametrizedResourceQuery<NodeContext[]> childQuery;
    private final ParametrizedResourceQuery<Boolean> hasChildQuery;
    private final Listener<NodeContext[]> childQueryProcedure;
    private final Listener<Boolean> hasChildQueryProcedure;
    private final PrimitiveQueryUpdater updater;
    private final NodeContext context;
    private final BuiltinKeys.ViewpointKey key;

    public abstract NodeContext[] children(ReadGraph var1) throws DatabaseException;

    public abstract Boolean hasChildren(ReadGraph var1) throws DatabaseException;

    public LazyParametrizedViewpoint(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointKey key, Object ... parameters) {
        assert (updater != null);
        assert (context != null);
        assert (key != null);
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.childQuery = new ParametrizedResourceQuery<NodeContext[]>((Object)Pair.make(((Object)((Object)this)).getClass(), (Object)CHILDREN), context, parameters){

            public NodeContext[] perform(ReadGraph graph) throws DatabaseException {
                return LazyParametrizedViewpoint.this.children(graph);
            }
        };
        this.childQueryProcedure = new Listener<NodeContext[]>(){

            public void execute(NodeContext[] result) {
                LazyParametrizedViewpoint.this.replaceChildrenResult(result);
            }

            public boolean isDisposed() {
                return LazyParametrizedViewpoint.this.updater.isDisposed();
            }

            public void exception(Throwable t) {
                System.out.print("LazyParametrizedViewpoint2.childQuery failed: ");
                t.printStackTrace();
            }
        };
        this.hasChildQuery = new ParametrizedResourceQuery<Boolean>((Object)Pair.make(((Object)((Object)this)).getClass(), (Object)HAS_CHILDREN), context, parameters){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return LazyParametrizedViewpoint.this.hasChildren(graph);
            }
        };
        this.hasChildQueryProcedure = new Listener<Boolean>(){

            public void execute(Boolean result) {
                LazyParametrizedViewpoint.this.replaceHasChildrenResult(result);
            }

            public boolean isDisposed() {
                return LazyParametrizedViewpoint.this.updater.isDisposed();
            }

            public void exception(Throwable t) {
                System.out.print("LazyParametrizedViewpoint2.hasChildQuery failed: ");
                t.printStackTrace();
            }
        };
    }

    public NodeContext getContext() {
        return this.context;
    }

    public NodeContext[] getChildren() {
        DataSource source;
        if (this.children == Viewpoint.PENDING_CHILDREN && (source = this.updater.getDataSource(ReadGraph.class)) != null) {
            source.schedule((Callback)new Callback<ReadGraph>(){

                public void run(ReadGraph source) {
                    source.asyncRequest((Read)LazyParametrizedViewpoint.this.childQuery, LazyParametrizedViewpoint.this.childQueryProcedure);
                }
            });
        }
        return this.children;
    }

    public Boolean getHasChildren() {
        DataSource source;
        if (this.hasChildren == Viewpoint.PENDING_HAS_CHILDREN && (source = this.updater.getDataSource(ReadGraph.class)) != null) {
            source.schedule((Callback)new Callback<ReadGraph>(){

                public void run(ReadGraph source) {
                    source.asyncRequest((Read)LazyParametrizedViewpoint.this.hasChildQuery, LazyParametrizedViewpoint.this.hasChildQueryProcedure);
                }
            });
        }
        return this.hasChildren;
    }

    protected void replaceChildrenResult(NodeContext[] result) {
        this.setChildren(this.updater, result);
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    protected void replaceHasChildrenResult(Boolean result) {
        this.setHasChildren(result);
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    protected <T> T getInput(Class<T> clazz) throws ClassCastException {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o == null) {
            throw new NullPointerException("null input");
        }
        return clazz.cast(o);
    }

    protected <T> T tryGetInput(Class<T> clazz) {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        return null;
    }
}

