/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.representation.StringRepresentation2;
import org.simantics.utils.datastructures.slice.ValueRange;

public final class LabelerUtil {
    public static String safeStringRepresentation(ReadGraph g, Resource r) throws DatabaseException {
        try {
            String rep = (String)g.adapt(r, String.class);
            return rep;
        }
        catch (AdaptionException e) {
            return "<no string representation: " + e.getMessage() + ">";
        }
        catch (DatabaseException e) {
            return NameUtils.getSafeName((ReadGraph)g, (Resource)r);
        }
    }

    public static String safeStringRepresentation(ReadGraph g, Resource r, int index) throws DatabaseException {
        try {
            StringRepresentation2 rep = (StringRepresentation2)g.adapt(r, StringRepresentation2.class);
            return rep.get(g, index);
        }
        catch (AdaptionException e) {
            return "<no string representation: " + e.getMessage() + ">";
        }
    }

    public static String safeStringRepresentation(ReadGraph g, Resource r, ValueRange range) throws DatabaseException {
        try {
            StringRepresentation2 rep = (StringRepresentation2)g.adapt(r, StringRepresentation2.class);
            return rep.get(g, range.start(), range.size());
        }
        catch (AdaptionException e) {
            return "<no string representation: " + e.getMessage() + ">";
        }
    }
}

