/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.request.GetLabel;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class LabelModifier
implements Labeler.Modifier,
Callback<DatabaseException> {
    private final Session session;
    protected final Resource resource;
    protected final Resource targetProperty;

    public LabelModifier(Session session, Resource resource) {
        this(session, resource, ((Layer0)session.getService(Layer0.class)).HasLabel);
    }

    public LabelModifier(Session session, Resource resource, Resource targetProperty) {
        this.session = session;
        this.resource = resource;
        this.targetProperty = targetProperty;
    }

    public String getValue() {
        try {
            return (String)this.session.syncRequest((Read)new GetLabel(this.resource));
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogWarning((String)"Problem reading current label, see exception for details.", (Throwable)e);
            return "";
        }
    }

    public String isValid(String label) {
        if (label.isEmpty()) {
            return "Empty label not allowed";
        }
        return null;
    }

    public void modify(String label) {
        this.session.asyncRequest(this.getWriteRequest(label), (Callback)this);
    }

    protected Write getWriteRequest(final String label) {
        return new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                g.claimLiteral(LabelModifier.this.resource, LabelModifier.this.targetProperty, (Object)label);
            }
        };
    }

    public void run(DatabaseException parameter) {
        if (parameter != null) {
            ExceptionUtils.logError((String)"Label modification failed, see exception for details.", (Throwable)parameter);
        }
    }
}

