/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.common.property.IPropertyFactory;
import org.simantics.browsing.ui.common.property.PropertyUtil;
import org.simantics.browsing.ui.graph.impl.IsEnumeratedValue;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.slice.Sliceable;
import org.simantics.utils.datastructures.slice.ValueRange;

public class GraphPropertyUtil {
    public static String tryGetValueTypeString(ReadGraph graph, Resource resource, int sizeHint) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, l0.OrderedSet)) {
            return "list";
        }
        try {
            Resource literalType = graph.getSingleType(resource, l0.Literal);
            String literalTypeName = (String)graph.getRelatedValue(literalType, l0.HasName, (Binding)Bindings.STRING);
            Datatype dt = graph.getDataType(resource);
            String typeString = null;
            if (dt instanceof ArrayType) {
                ArrayType at = (ArrayType)dt;
                at = (ArrayType)Bindings.getBindingUnchecked(Datatype.class).clone((Object)at);
                at.setLength("" + sizeHint);
                typeString = at.toSingleLineString();
            } else {
                typeString = dt.toSingleLineString();
            }
            return String.valueOf(literalTypeName) + " : " + typeString;
        }
        catch (RuntimeBindingConstructionException literalType) {
        }
        catch (AdaptException literalType) {
        }
        catch (DatabaseException literalType) {
            // empty catch block
        }
        if (!graph.isInstanceOf(resource, l0.Literal)) {
            return PropertyUtil.ValueType.toString((PropertyUtil.ValueType)PropertyUtil.ValueType.NoValue);
        }
        try {
            Object value = graph.getValue(resource);
            return PropertyUtil.ValueType.toString((PropertyUtil.ValueType)PropertyUtil.ValueType.convert((Object)value));
        }
        catch (DoesNotContainValueException ee) {
            return PropertyUtil.ValueType.toString((PropertyUtil.ValueType)PropertyUtil.ValueType.NoValue);
        }
    }

    public static <T extends IProperty> T createProperty(ReadGraph graph, Resource resource, IPropertyFactory<T> propertyFactory) throws DatabaseException {
        T t = GraphPropertyUtil.tryCreateProperty(graph, resource, propertyFactory);
        if (t != null) {
            return t;
        }
        return (T)propertyFactory.create(null);
    }

    public static <T extends IProperty> T tryCreateProperty(ReadGraph graph, Resource resource, IPropertyFactory<T> propertyFactory) throws DatabaseException {
        boolean isEnum = IsEnumeratedValue.isEnumeratedValue(graph, resource);
        if (isEnum) {
            return (T)propertyFactory.create(null);
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        boolean isLiteral = graph.isInstanceOf(resource, l0.Literal);
        if (isLiteral) {
            try {
                Object value = graph.getValue(resource);
                if (value.getClass().isArray()) {
                    int size = Array.getLength(value);
                    if (size > 1) {
                        return (T)propertyFactory.create(ValueRange.make((int)0, (int)size));
                    }
                    if (size == 0) {
                        return (T)propertyFactory.create(ValueRange.make((int)0, (int)0));
                    }
                }
                return (T)propertyFactory.create(null);
            }
            catch (DoesNotContainValueException value) {}
        } else {
            boolean isList = graph.isInstanceOf(resource, l0.OrderedSet);
            if (isList) {
                int size = OrderedSetUtils.toList((ReadGraph)graph, (Resource)resource).size();
                return (T)propertyFactory.create(ValueRange.make((int)0, (int)size));
            }
        }
        return null;
    }

    public static <T extends IProperty> NodeContext[] tryValueGetChildren(ReadGraph graph, Resource resource, IPropertyFactory<T> propertyFactory) throws DatabaseException {
        T property = GraphPropertyUtil.tryCreateProperty(graph, resource, propertyFactory);
        if (property == null) {
            return null;
        }
        if (property instanceof IArrayProperty) {
            IArrayProperty array = (IArrayProperty)property;
            ValueRange range = array.getRange();
            Collection children = PropertyUtil.subnodify((Sliceable)array, (int)0, (int)range.size());
            return NodeContextUtil.toContextsWithInput((Collection)children);
        }
        return NodeContext.NONE;
    }

    public static Boolean tryValueHasChildren(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(r, l0.Literal)) {
            try {
                Object o = graph.getValue(r);
                return Array.getLength(o) > 1;
            }
            catch (DoesNotContainValueException e) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

