/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.common.modifiers.EnumerationValue;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class GetEnumerationValue
extends ResourceRead<EnumerationValue<Resource>> {
    public GetEnumerationValue(Resource resource) {
        super(resource);
    }

    public EnumerationValue<Resource> perform(ReadGraph graph) throws DatabaseException {
        return GetEnumerationValue.enumerate(graph, this.resource);
    }

    public static EnumerationValue<Resource> enumerate(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Set types = graph.getTypes(resource);
        if (types.contains(l0.Boolean)) {
            ArrayList<EnumeratedValue> values = new ArrayList<EnumeratedValue>(2);
            values.add(new EnumeratedValue(Boolean.FALSE.toString(), (Object)l0.False));
            values.add(new EnumeratedValue(Boolean.TRUE.toString(), (Object)l0.True));
            Boolean currentValue = (Boolean)graph.getPossibleValue(resource, (Binding)Bindings.BOOLEAN);
            Enumeration enumeration = new Enumeration(values);
            EnumeratedValue current = Boolean.TRUE.equals(currentValue) ? (EnumeratedValue)values.get(1) : (EnumeratedValue)values.get(0);
            return new EnumerationValue(enumeration, current);
        }
        for (Resource type : types) {
            if (!graph.hasStatement(type, l0.Enumeration, type)) continue;
            Collection values = graph.getObjects(type, l0.ConsistsOf);
            ArrayList<EnumeratedValue> result = new ArrayList<EnumeratedValue>(values.size());
            for (Resource value : values) {
                result.add(new EnumeratedValue(GetEnumerationValue.safeName(graph, value), (Object)value));
            }
            Enumeration enumeration = new Enumeration(result);
            return new EnumerationValue(enumeration, enumeration.find((Object)resource));
        }
        return null;
    }

    private static String safeName(ReadGraph graph, Resource value) throws DatabaseException {
        return (String)graph.syncRequest((Read)new NameRequest(value));
    }

    public static class NameRequest
    extends ResourceRead<String> {
        public NameRequest(Resource resource) {
            super(resource);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            try {
                return (String)graph.adapt(this.resource, String.class);
            }
            catch (AdaptionException e) {
                return NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource);
            }
        }
    }
}

