/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.DataSource;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.AsyncReadRequest;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public class AsyncReadGraphDataSource
implements DataSource<AsyncReadGraph> {
    private final AsyncRequestProcessor processor;
    private final LifecycleSupport ls;

    public AsyncReadGraphDataSource(AsyncRequestProcessor processor) {
        this.processor = processor;
        this.ls = (LifecycleSupport)processor.getService(LifecycleSupport.class);
    }

    public void schedule(final Callback<AsyncReadGraph> callback) {
        if (this.ls.isClosing() || this.ls.isClosed()) {
            return;
        }
        this.processor.asyncRequest((AsyncRead)new AsyncReadRequest(){

            public void run(AsyncReadGraph graph) {
                if (AsyncReadGraphDataSource.this.ls.isClosing() || AsyncReadGraphDataSource.this.ls.isClosed()) {
                    return;
                }
                callback.run((Object)graph);
            }
        }, (Procedure)new ProcedureAdapter<Object>(){

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        });
    }

    public Class<AsyncReadGraph> getProvidedClass() {
        return AsyncReadGraph.class;
    }
}

