/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.function;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleActiveRun;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.common.celleditor.GraphCellEditorAdapter;
import org.simantics.spreadsheet.common.matrix.VariantMatrix;
import org.simantics.spreadsheet.graph.Ranges;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.structural.stubs.StructuralResource2;

public class All {
    private static Set<String> CLASSIFICATIONS = new HashSet<String>();
    private static ConstantPropertyVariableBuilder immutableBuilder = new ConstantPropertyVariableBuilder("immutable", (Object)true, (Binding)Bindings.BOOLEAN);
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor contentValueAccessor;
    @SCLValue(type="VariableMap")
    public static VariableMap stringArrayChildren;
    @SCLValue(type="VariableMap")
    public static VariableMap doubleArrayChildren;
    @SCLValue(type="VariableMap")
    public static VariableMap spreadsheetChildren;
    @SCLValue(type="VariableMap")
    public static VariableMap sheetRunDomainChildren;

    static {
        CLASSIFICATIONS.add("http://www.simantics.org/Spreadsheet-1.2/Attribute");
        contentValueAccessor = new ValueAccessor(){

            public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
                if (value instanceof String) {
                    String text = (String)value;
                    SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                    if (!Layer0Utils.setOrClearExpression((WriteGraph)graph, (Variable)context, (String)text, (Resource)SHEET.SCLValue)) {
                        org.simantics.db.layer0.function.All.standardValueAccessor.setValue(graph, context, (Object)Variant.ofInstance((Object)value), (Binding)Bindings.VARIANT);
                    }
                    return;
                }
                String expression = (String)context.getPossiblePropertyValue((ReadGraph)graph, "expression");
                if (expression != null) {
                    Object current_ = context.getPossibleValue((ReadGraph)graph);
                    if (current_ instanceof Variable) {
                        Variable current = (Variable)current_;
                        current.setValue(graph, value, binding);
                        return;
                    }
                    SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                    Layer0Utils.clearExpression((WriteGraph)graph, (Variable)context, (Resource)SHEET.SCLValue);
                }
                org.simantics.db.layer0.function.All.standardValueAccessor.setValue(graph, context, value, binding);
            }

            public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
                if (value instanceof String) {
                    this.setValue(graph, context, value, (Binding)Bindings.STRING);
                } else if (value instanceof Variant) {
                    this.setValue(graph, context, value, (Binding)Bindings.VARIANT);
                } else {
                    throw new DatabaseException("Unsupported value type " + value);
                }
            }

            public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
                return org.simantics.db.layer0.function.All.standardValueAccessor.getValue(graph, context, binding);
            }

            public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
                return org.simantics.db.layer0.function.All.standardValueAccessor.getValue(graph, context);
            }
        };
        stringArrayChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                THashMap map = new THashMap();
                this.getVariables(graph, context, (Map<String, Variable>)map);
                return (Variable)map.get((Object)name);
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                Resource resource = context.getRepresents(graph);
                SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                String location = (String)graph.getPossibleRelatedValue(resource, sr.Range_location, (Binding)Bindings.STRING);
                if (location == null) {
                    return map;
                }
                Integer width = (Integer)graph.getPossibleRelatedValue(resource, sr.Range_widthBound, (Binding)Bindings.INTEGER);
                if (width == null) {
                    return map;
                }
                String[] array = (String[])graph.getPossibleRelatedValue(resource, sr.StringArrayRange_array, (Binding)Bindings.STRING_ARRAY);
                if (array == null) {
                    return map;
                }
                int rows = array.length / width;
                if (map == null) {
                    map = new HashMap<String, Variable>();
                }
                int offset = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < width) {
                        String value = array[offset++];
                        String valueLocation = SpreadsheetUtils.offset((String)location, (int)i, (int)j);
                        ConstantPropertyVariableBuilder labelBuilder = new ConstantPropertyVariableBuilder("label", (Object)value, (Binding)Bindings.STRING, Collections.emptyList(), CLASSIFICATIONS);
                        ConstantPropertyVariableBuilder typeBuilder = new ConstantPropertyVariableBuilder("Type", (Object)sr.Cell, null, Collections.emptyList(), Collections.emptySet());
                        map.put(valueLocation, (Variable)new ConstantChildVariable(context, valueLocation, new ConstantPropertyVariableBuilder[]{labelBuilder, typeBuilder, immutableBuilder}));
                        ++j;
                    }
                    ++i;
                }
                return map;
            }
        };
        doubleArrayChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                THashMap map = new THashMap();
                this.getVariables(graph, context, (Map<String, Variable>)map);
                return (Variable)map.get((Object)name);
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                Resource resource = context.getRepresents(graph);
                SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                String location = (String)graph.getPossibleRelatedValue(resource, sr.Range_location, (Binding)Bindings.STRING);
                if (location == null) {
                    return map;
                }
                Integer width = (Integer)graph.getPossibleRelatedValue(resource, sr.Range_widthBound, (Binding)Bindings.INTEGER);
                if (width == null) {
                    return map;
                }
                double[] array = (double[])graph.getPossibleRelatedValue(resource, sr.DoubleArrayRange_array, (Binding)Bindings.DOUBLE_ARRAY);
                if (array == null) {
                    return map;
                }
                if (map == null) {
                    map = new HashMap<String, Variable>();
                }
                int rows = array.length / width;
                int offset = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < width) {
                        double value = array[offset++];
                        String valueLocation = SpreadsheetUtils.offset((String)location, (int)i, (int)j);
                        ConstantPropertyVariableBuilder labelBuilder = new ConstantPropertyVariableBuilder("label", (Object)String.valueOf(value), (Binding)Bindings.STRING, Collections.emptyList(), CLASSIFICATIONS);
                        ConstantPropertyVariableBuilder typeBuilder = new ConstantPropertyVariableBuilder("Type", (Object)sr.Cell, null, Collections.emptyList(), Collections.emptySet());
                        map.put(valueLocation, (Variable)new ConstantChildVariable(context, valueLocation, new ConstantPropertyVariableBuilder[]{labelBuilder, typeBuilder, immutableBuilder}));
                        ++j;
                    }
                    ++i;
                }
                return map;
            }
        };
        spreadsheetChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                Variable var = org.simantics.db.layer0.function.All.standardChildDomainChildren.getVariable(graph, context, name);
                if (var == null) {
                    var = this.getPossibleRangeChild(graph, context, name);
                }
                if (var == null) {
                    var = this.getPossibleDeepChild(graph, context, name);
                }
                return var;
            }

            private Variable getPossibleDeepChild(ReadGraph graph, Variable context, String name) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                for (Variable range : (Collection)graph.syncRequest((Read)new Ranges(context), (Listener)TransientCacheListener.instance())) {
                    Variable cell;
                    String location = (String)range.getPropertyValue(graph, SHEET.Range_location, (Binding)Bindings.STRING);
                    Integer widthBound = (Integer)range.getPropertyValue(graph, SHEET.Range_widthBound, (Binding)Bindings.INTEGER);
                    Integer heightBound = (Integer)range.getPropertyValue(graph, SHEET.Range_heightBound, (Binding)Bindings.INTEGER);
                    if (!SpreadsheetUtils.isInBounds((String)location, (String)name, (int)widthBound, (int)heightBound) || (cell = range.getPossibleChild(graph, name)) == null) continue;
                    return cell;
                }
                return null;
            }

            private Variable getPossibleRangeChild(ReadGraph graph, Variable context, String name) throws DatabaseException {
                String[] propertyNames = new String[]{"content", "rangeCellNames", "Represents", "HasLabel", "immutable"};
                Binding[] bindingArray = new Binding[5];
                bindingArray[0] = Bindings.VARIANT;
                bindingArray[3] = Bindings.STRING;
                bindingArray[4] = Bindings.BOOLEAN;
                Binding[] bindings = bindingArray;
                if (name.contains(":")) {
                    Range range = SpreadsheetUtils.decodeRange((String)name, (int)0, (int)0);
                    VariantMatrix matrix = new VariantMatrix(range.height(), range.width());
                    String[][] rangeNames = new String[range.height()][range.width()];
                    int x = range.startColumn;
                    while (x <= range.endColumn) {
                        int y = range.startRow;
                        while (y <= range.endRow) {
                            String location = SpreadsheetUtils.cellName((int)y, (int)x);
                            Variable child = context.getPossibleChild(graph, location);
                            Variant value = null;
                            if (child != null) {
                                value = (Variant)child.getPossiblePropertyValue(graph, "content", (Binding)Bindings.VARIANT);
                            }
                            matrix.set(y - range.startRow, x - range.startColumn, value);
                            rangeNames[y - range.startRow][x - range.startColumn] = location;
                            ++y;
                        }
                        ++x;
                    }
                    Object[] objectArray = new Object[5];
                    objectArray[0] = Variant.ofInstance((Object)matrix);
                    objectArray[1] = rangeNames;
                    objectArray[3] = name;
                    objectArray[4] = Boolean.FALSE;
                    Object[] values = objectArray;
                    ArrayList<ConstantPropertyVariableBuilder> list = new ArrayList<ConstantPropertyVariableBuilder>();
                    int i = 0;
                    while (i < propertyNames.length) {
                        list.add(new ConstantPropertyVariableBuilder(propertyNames[i], values[i], bindings[i]));
                        ++i;
                    }
                    return new ConstantChildVariable(context, name, list);
                }
                return null;
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                return org.simantics.db.layer0.function.All.standardChildDomainChildren.getVariables(graph, context, map);
            }
        };
        sheetRunDomainChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                Map children = (Map)graph.syncRequest((Read)new SheetRunChildMapOfResource(context.getRepresents(graph)));
                Resource child = (Resource)children.get(name);
                return org.simantics.db.layer0.function.All.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (Resource)child, (String)name);
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
                Map children = (Map)graph.syncRequest((Read)new SheetRunChildMapOfResource(variable.resource));
                return org.simantics.db.layer0.function.All.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, (Map)children, map);
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> String")
    public static String cellLabel(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Resource) {
            return NameUtils.getSafeLabel((ReadGraph)graph, (Resource)((Resource)context));
        }
        if (context instanceof Variable) {
            Variable parent = ((Variable)context).getParent(graph);
            Variable content = parent.getPossibleProperty(graph, "content");
            if (content != null) {
                Databoard db = (Databoard)graph.getService(Databoard.class);
                Variant variant = (Variant)content.getValue(graph, (Binding)db.VARIANT);
                return variant.getValue().toString();
            }
            return parent.getName(graph);
        }
        throw new DatabaseException("Unknown context " + context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> CellEditor")
    public static CellEditor defaultSheetCellEditor(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        final Variable sheet = context_.getParent(graph);
        return new GraphCellEditorAdapter(){

            public <T> void edit(final CellEditor.Transaction transaction, final String location, final String property, final T value, final Binding binding) {
                SpreadsheetUtils.schedule((CellEditor.Transaction)transaction, (Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                        Variable cellVariable = sheet.getPossibleChild((ReadGraph)graph, location);
                        if (cellVariable == null) {
                            this.defaultCreate(graph, location, Variant.ofInstance((Object)""));
                            cellVariable = sheet.getPossibleChild((ReadGraph)graph, location);
                            if (cellVariable == null) {
                                throw new DatabaseException("Unexpected problem while creating spreadsheet cell at '" + location + "'");
                            }
                        }
                        CellEditor editor = (CellEditor)cellVariable.getPropertyValue((ReadGraph)graph, SHEET.cellEditor);
                        editor.edit(transaction, location, property, value, binding);
                    }
                });
            }

            public void defaultCreate(WriteGraph graph, String location, Variant value) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                Resource container = sheet.getRepresents((ReadGraph)graph);
                Resource cell = graph.newResource();
                graph.claim(cell, L0.InstanceOf, null, SHEET.TextCell);
                graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, (Object)location, (Binding)Bindings.STRING);
                graph.addLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, (Object)value, (Binding)Bindings.VARIANT);
                graph.claim(cell, L0.PartOf, container);
                Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Created cell on location " + location + " with value " + value.getValue().toString()));
            }

            public void edit(final CellEditor.Transaction transaction, final String location, final Variant value) {
                SpreadsheetUtils.schedule((CellEditor.Transaction)transaction, (Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                        System.err.println("sheet: " + sheet.getURI((ReadGraph)graph));
                        Variable cellVariable = sheet.getPossibleChild((ReadGraph)graph, location);
                        if (cellVariable == null) {
                            this.defaultCreate(graph, location, value);
                            return;
                        }
                        CellEditor editor = (CellEditor)cellVariable.getPropertyValue((ReadGraph)graph, SHEET.cellEditor);
                        editor.edit(transaction, location, value);
                    }
                });
            }

            public void copy(final CellEditor.Transaction transaction, final String location, final MutableVariant variant) {
                SpreadsheetUtils.schedule((CellEditor.Transaction)transaction, (Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        CellEditor editor;
                        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                        Variable variable = sheet.getPossibleChild((ReadGraph)graph, location);
                        if (variable != null && (editor = (CellEditor)variable.getPossiblePropertyValue((ReadGraph)graph, SHEET.cellEditor)) != null) {
                            editor.copy(transaction, location, variant);
                        }
                    }
                });
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> CellEditor")
    public static CellEditor variableCellEditor(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        final Variable cell = context_.getParent(graph);
        return new GraphCellEditorAdapter(){

            public <T> void edit(WriteGraph graph, String location, String property, T value, Binding binding) throws DatabaseException {
                cell.setPropertyValue(graph, property, value, binding);
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> CellEditor")
    public static CellEditor textCellEditor(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        final Variable cell = context_.getParent(graph);
        return new GraphCellEditorAdapter(){

            public <T> void edit(WriteGraph graph, String location, String property, T value, Binding binding) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                if ("content".equals(property)) {
                    cell.setPropertyValue(graph, SHEET.Cell_content, value, (Binding)Bindings.VARIANT);
                } else if ("content#expression".equals(property)) {
                    cell.setPropertyValue(graph, SHEET.Cell_content, value, (Binding)Bindings.STRING);
                } else if ("border".equals(property)) {
                    cell.setPropertyValue(graph, SHEET.Cell_border, value, (Binding)Bindings.INTEGER);
                } else if ("align".equals(property)) {
                    cell.setPropertyValue(graph, SHEET.Cell_align, value, (Binding)Bindings.INTEGER);
                } else if ("font".equals(property)) {
                    Resource represents = cell.getPossibleRepresents((ReadGraph)graph);
                    if (represents == null) {
                        return;
                    }
                    DatatypeResource DATATYPES = DatatypeResource.getInstance((ReadGraph)graph);
                    graph.claimLiteral(represents, SHEET.Cell_font, DATATYPES.Font, value, Font.BINDING);
                } else if ("foreground".equals(property)) {
                    Resource represents = cell.getPossibleRepresents((ReadGraph)graph);
                    if (represents == null) {
                        return;
                    }
                    DatatypeResource DATATYPES = DatatypeResource.getInstance((ReadGraph)graph);
                    graph.claimLiteral(represents, SHEET.Cell_foreground, DATATYPES.RGB_Integer, value, RGB.Integer.BINDING);
                } else if ("background".equals(property)) {
                    Resource represents = cell.getPossibleRepresents((ReadGraph)graph);
                    if (represents == null) {
                        return;
                    }
                    DatatypeResource DATATYPES = DatatypeResource.getInstance((ReadGraph)graph);
                    graph.claimLiteral(represents, SHEET.Cell_background, DATATYPES.RGB_Integer, value, RGB.Integer.BINDING);
                }
            }

            public <T> void edit(WriteGraph graph, String location, Variant value) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                cell.setPropertyValue(graph, SHEET.Cell_content, (Object)value, (Binding)Bindings.VARIANT);
            }

            public void copy(WriteGraph graph, String location, MutableVariant variant) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                Variant content = (Variant)cell.getPropertyValue((ReadGraph)graph, SHEET.Cell_content, (Binding)Bindings.VARIANT);
                variant.setValue(content);
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable spreadsheetInput(ReadGraph graph, Resource converter, Variable sheet) throws DatabaseException {
        Variable context = Variables.getPossibleContext((ReadGraph)graph, (Variable)sheet);
        return (Variable)context.getPossiblePropertyValue(graph, StructuralResource2.getInstance((ReadGraph)graph).input);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable spreadsheetRunInput(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)property);
        Variable activeRun = (Variable)graph.syncRequest((Read)new PossibleActiveRun(model));
        if (activeRun != null) {
            return activeRun;
        }
        return Variables.getConfigurationContext((ReadGraph)graph, (Resource)model);
    }

    static class SheetRunChildMapOfResource
    extends ResourceRead<Map<String, Resource>> {
        public SheetRunChildMapOfResource(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(this.resource));
            if (model == null) {
                return Collections.emptyMap();
            }
            SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
            Instances query = (Instances)graph.adapt(SHEET.Book, Instances.class);
            HashMap<String, Resource> result = new HashMap<String, Resource>();
            for (Resource book : query.find(graph, model)) {
                String name = (String)graph.getPossibleRelatedValue(book, L0.HasName, (Binding)Bindings.STRING);
                if (name == null) continue;
                result.put(name, book);
            }
            return result;
        }
    }
}

