/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.ExtendedGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.common.matrix.VariantMatrix;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class SpreadsheetVariable
extends ExtendedGraphChildVariable {
    final String[] propertyNames = new String[]{"content", "Represents", "HasLabel", "immutable"};
    final Binding[] bindings;

    public SpreadsheetVariable(Variable parent, Resource resource) throws DatabaseException {
        super(parent, resource);
        Binding[] bindingArray = new Binding[4];
        bindingArray[0] = Bindings.VARIANT;
        bindingArray[2] = Bindings.STRING;
        bindingArray[3] = Bindings.BOOLEAN;
        this.bindings = bindingArray;
    }

    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        if (VariableSpaceManipulator.class == clazz) {
            return (T)new VariableSpaceManipulator(){

                public void apply(WriteGraph graph, VariableSpaceManipulator.Modification modification) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    String[] stringArray = modification.removedChildren;
                    int n = modification.removedChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        Variable child = SpreadsheetVariable.this.getChild((ReadGraph)graph, name);
                        Resource represents = child.getRepresents((ReadGraph)graph);
                        graph.deny(represents, L0.PartOf);
                        ++n2;
                    }
                    stringArray = modification.newChildren;
                    n = modification.newChildren.length;
                    n2 = 0;
                    while (n2 < n) {
                        String data = stringArray[n2];
                        Resource container = SpreadsheetVariable.this.getRepresents((ReadGraph)graph);
                        Resource cell = graph.newResource();
                        Resource type = graph.getResource(((VariableSpaceManipulator.ChildCreationData)data).type);
                        graph.claim(cell, L0.InstanceOf, null, type);
                        graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, (Object)((VariableSpaceManipulator.ChildCreationData)data).name, (Binding)Bindings.STRING);
                        VariableSpaceManipulator.PropertyCreationData[] propertyCreationDataArray = ((VariableSpaceManipulator.ChildCreationData)data).properties;
                        int n3 = ((VariableSpaceManipulator.ChildCreationData)data).properties.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            VariableSpaceManipulator.PropertyCreationData p = propertyCreationDataArray[n4];
                            Resource property = graph.getResource(p.name);
                            graph.claimLiteral(cell, property, p.value.getValue());
                            ++n4;
                        }
                        graph.claim(cell, L0.PartOf, container);
                        ++n2;
                    }
                }
            };
        }
        return (T)super.adapt(graph, clazz);
    }

    public Variable getPossibleSpecialChild(ReadGraph graph, String name) throws DatabaseException {
        if (name.contains(":")) {
            Range range = SpreadsheetUtils.decodeRange((String)name, (int)0, (int)0);
            VariantMatrix matrix = new VariantMatrix(range.height(), range.width());
            int x = range.startColumn;
            while (x <= range.endColumn) {
                int y = range.startRow;
                while (y <= range.endRow) {
                    String location = SpreadsheetUtils.cellName((int)y, (int)x);
                    Variable child = this.getPossibleChild(graph, location);
                    Variant value = null;
                    if (child != null) {
                        value = (Variant)child.getPossiblePropertyValue(graph, "content", (Binding)Bindings.VARIANT);
                    }
                    matrix.set(y - range.startRow, x - range.startColumn, value);
                    ++y;
                }
                ++x;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = Variant.ofInstance((Object)matrix);
            objectArray[2] = name;
            objectArray[3] = false;
            return new ConstantChildVariable((Variable)this, name, this.propertyNames, this.bindings, objectArray);
        }
        return super.getPossibleSpecialChild(graph, name);
    }
}

