/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.AsyncListenerSupport;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.procedure.adapter.SyncListenerSupport;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.single.SingleSetSyncListenerDelegate;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.session.SessionEventListenerAdapter;
import org.simantics.db.event.SessionEventListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.service.SessionEventSupport;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.CellModifier;
import org.simantics.spreadsheet.CommandCellExecutor;
import org.simantics.spreadsheet.common.cell.SheetManipulator;
import org.simantics.spreadsheet.common.logging.Logger;
import org.simantics.spreadsheet.event.model.RemoveCellHandler;
import org.simantics.spreadsheet.graph.Cells;
import org.simantics.spreadsheet.graph.FilteredVariableProperties;
import org.simantics.spreadsheet.graph.Ranges;
import org.simantics.spreadsheet.graph.adapter.SheetVariableSpaceManipulator;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class GraphUI
implements Adaptable,
ListenerSupport,
AsyncListenerSupport,
SyncListenerSupport {
    public static final boolean DEBUG = false;
    private final RequestProcessor processor;
    private CellEditor cellEditor;
    private Variable variable;

    public GraphUI(RequestProcessor processor) {
        this.processor = processor;
    }

    public void addCell(ReadGraph graph, Pair<String, Variable> child, CellModifier client) throws DatabaseException {
        String childName = ((Variable)child.second).getName(graph);
        Boolean immutable = (Boolean)((Variable)child.second).getPossiblePropertyValue(graph, "immutable", (Binding)Bindings.BOOLEAN);
        if (immutable != null && immutable.booleanValue()) {
            Collection properties = ((Variable)child.second).getProperties(graph, "http://www.simantics.org/Spreadsheet-1.2/Attribute");
            this.addProperties(graph, properties, client, childName);
        } else {
            graph.asyncRequest((Read)new FilteredVariableProperties((Variable)child.second), this.propertyListener(client, childName));
        }
    }

    public void removeCell(ReadGraph graph, Pair<String, Variable> child, CellModifier client) throws DatabaseException {
        client.clear((String)child.first);
    }

    public void loadCells(ReadGraph graph, Variable container, boolean immutable, final CellModifier client) throws DatabaseException {
        if (immutable) {
            for (Pair cell : (Collection)graph.syncRequest((Read)new Cells(this.variable), (AsyncProcedure)TransientCacheAsyncListener.instance())) {
                this.addCell(graph, (Pair<String, Variable>)cell, client);
            }
        } else {
            graph.syncRequest((Read)new Cells(this.variable), (AsyncProcedure)new SingleSetSyncListenerDelegate<Pair<String, Variable>>((AsyncListenerSupport)this){

                public void add(ReadGraph graph, Pair<String, Variable> child) throws DatabaseException {
                    GraphUI.this.addCell(graph, child, client);
                }

                public void remove(ReadGraph graph, Pair<String, Variable> child) throws DatabaseException {
                    GraphUI.this.removeCell(graph, child, client);
                }
            });
        }
    }

    public Resource load(final Variable variable, final CellModifier client) throws DatabaseException {
        assert (variable != null);
        this.variable = variable;
        SessionEventSupport support = (SessionEventSupport)this.processor.getService(SessionEventSupport.class);
        support.addListener((SessionEventListener)new SessionEventListenerAdapter(){

            public void writeTransactionFinished() {
                client.flush();
            }
        });
        this.cellEditor = (CellEditor)this.processor.sync((ReadInterface)new VariableRead<CellEditor>(variable){

            public CellEditor perform(ReadGraph graph) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                return (CellEditor)this.variable.getPropertyValue(graph, SHEET.cellEditor);
            }
        });
        final ITask task = ThreadLogger.getInstance().begin("GraphUI.init");
        this.processor.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                GraphUI.this.loadCells(graph, variable, false, client);
                graph.syncRequest((Read)new Ranges(variable), (AsyncProcedure)new SingleSetSyncListenerDelegate<Variable>((AsyncListenerSupport)GraphUI.this){

                    public void add(ReadGraph graph, Variable range) throws DatabaseException {
                        Boolean immutable = (Boolean)range.getPossiblePropertyValue(graph, "immutable", (Binding)Bindings.BOOLEAN);
                        GraphUI.this.loadCells(graph, range, immutable != null && immutable != false, client);
                    }

                    public void remove(ReadGraph graph, Variable range) throws DatabaseException {
                    }
                });
            }
        }, (Procedure)new ProcedureAdapter<Object>(){

            public void execute(Object result) {
                task.finish();
                client.flush();
            }
        });
        return null;
    }

    private AsyncListener<Collection<Pair<String, Variable>>> propertyListener(final CellModifier client, final String childName) {
        return new SingleSetSyncListenerDelegate<Pair<String, Variable>>((AsyncListenerSupport)this){

            public void add(ReadGraph graph, final Pair<String, Variable> property) throws DatabaseException {
                graph.asyncRequest((Read)new CellValue((Variable)property.second), (SyncListener)new SyncListener<Object>(){

                    public void execute(ReadGraph graph, Object value) throws DatabaseException {
                        String propertyName = (String)property.first;
                        client.setProperty(childName, propertyName, value);
                    }

                    public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
                        String propertyName = (String)property.first;
                        if ("content".equals(propertyName)) {
                            client.setProperty(childName, propertyName, (Object)Variant.ofInstance((Object)throwable.getMessage()));
                        } else {
                            client.setProperty(childName, propertyName, null);
                        }
                    }

                    public boolean isDisposed() {
                        return GraphUI.this.isDisposed();
                    }
                });
            }
        };
    }

    private void addProperties(ReadGraph graph, Collection<Variable> properties, CellModifier client, String childName) throws DatabaseException {
        for (Variable property : properties) {
            String propertyName = property.getName(graph);
            Object value = property.getValue(graph);
            client.setProperty(childName, propertyName, value);
            String expression = (String)property.getPossiblePropertyValue(graph, "expression", (Binding)Bindings.STRING);
            if (expression == null) continue;
            client.setProperty(childName, String.valueOf(propertyName) + "#expression", (Object)expression);
        }
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (Variable.class == clazz) {
            return (T)this.variable;
        }
        if (SheetManipulator.class == clazz) {
            return (T)new SheetManipulator(){

                public void post(final VariableSpaceManipulator.Modification modification) {
                    try {
                        GraphUI.this.processor.syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                SheetVariableSpaceManipulator manipulator = new SheetVariableSpaceManipulator(GraphUI.this.variable);
                                manipulator.apply(graph, modification);
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            };
        }
        if (CommandCellExecutor.class == clazz) {
            return (T)new CommandCellExecutor(){

                public void execute(int row, int column) {
                    GraphUI.this.processor.asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                        }
                    });
                }
            };
        }
        if (RemoveCellHandler.class == clazz) {
            return (T)new RemoveCellHandler(){

                public void handle(final String location) {
                    GraphUI.this.processor.asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            Resource config;
                            Variable cellVariable = GraphUI.this.variable.getPossibleChild(graph, location);
                            if (cellVariable != null && (config = (Resource)cellVariable.getPossiblePropertyValue(graph, "Represents")) != null) {
                                graph.asyncRequest((Write)new WriteRequest(){

                                    public void perform(WriteGraph graph) throws DatabaseException {
                                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                                        graph.deny(config, l0.PartOf);
                                    }
                                });
                            }
                        }
                    });
                }
            };
        }
        if (CellEditor.class == clazz) {
            return (T)this.cellEditor;
        }
        return null;
    }

    public void exception(Throwable t) {
        t.printStackTrace();
    }

    public boolean isDisposed() {
        return false;
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        Logger.defaultLogError((String)"Failed to read properties.", (Throwable)t);
    }

    public void exception(ReadGraph graph, Throwable t) {
        Logger.defaultLogError((String)"Failed to read properties.", (Throwable)t);
    }

    static class CellValue
    extends VariableRead<Object> {
        public CellValue(Variable variable) {
            super(variable);
        }

        public Object perform(ReadGraph graph) throws DatabaseException {
            Object value = this.variable.getValue(graph);
            String propertyName = this.variable.getName(graph);
            if ("content".equals(propertyName)) {
                if (value instanceof Variable) {
                    Variable var = (Variable)value;
                    Object value2 = var.getValue(graph);
                    if (value2 instanceof Variant) {
                        return value;
                    }
                    try {
                        Binding binding = Bindings.getBinding(value2.getClass());
                        return new Variant(binding, value2);
                    }
                    catch (BindingConstructionException e) {
                        Logger.defaultLogError((Throwable)e);
                        return Variant.ofInstance((Object)("Unsupported content " + value2 + " from " + var.getURI(graph)));
                    }
                }
                if (!(value instanceof Variant)) {
                    try {
                        Binding binding = Bindings.getBinding(value.getClass());
                        return new Variant(binding, value);
                    }
                    catch (BindingConstructionException e) {
                        Logger.defaultLogError((Throwable)e);
                        return Variant.ofInstance((Object)("Unsupported content " + value + " at " + this.variable.getURI(graph)));
                    }
                }
            }
            return value;
        }
    }
}

