/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.datastructures.Pair;

public class Cells
extends UnaryRead<Variable, Collection<Pair<String, Variable>>> {
    public Cells(Variable variable) {
        super((Object)variable);
    }

    public Collection<Pair<String, Variable>> perform(ReadGraph graph) throws DatabaseException {
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        ArrayList<Pair<String, Variable>> result = new ArrayList<Pair<String, Variable>>();
        for (Variable child : ((Variable)this.parameter).getChildren(graph)) {
            Resource type = child.getType(graph);
            if (graph.isInheritedFrom(type, SHEET.Range)) {
                Collection rangeCells = (Collection)graph.sync((ReadInterface)new Cells(child));
                result.addAll(rangeCells);
                continue;
            }
            if (!graph.isInheritedFrom(type, SHEET.Cell)) continue;
            String name = child.getName(graph);
            result.add((Pair<String, Variable>)Pair.make((Object)name, (Object)child));
        }
        return result;
    }
}

