/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.tests;

import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class InstanceOfTest
implements Test {
    String bundleName;
    String className;
    Class<?> clazz;
    boolean failed;

    public InstanceOfTest(String bundle, String className) {
        this.bundleName = bundle;
        this.className = className;
    }

    public InstanceOfTest(ReadGraph graph, Resource test) throws DatabaseException {
        ViewpointResource VP = ViewpointResource.getInstance((ReadGraph)graph);
        this.bundleName = (String)graph.getRelatedValue(test, VP.InstanceOfTest_bundleName, (Binding)Bindings.STRING);
        this.className = (String)graph.getRelatedValue(test, VP.InstanceOfTest_className, (Binding)Bindings.STRING);
    }

    private Class<?> resolveClass() {
        if (this.failed) {
            return null;
        }
        if (this.clazz != null) {
            return this.clazz;
        }
        Bundle b = Platform.getBundle((String)this.bundleName);
        if (b == null) {
            System.err.println(this.getClass() + " could not resolve class " + this.className + ", bundle " + this.bundleName + " not found in platform");
            this.failed = true;
            return null;
        }
        try {
            this.clazz = b.loadClass(this.className);
            return this.clazz;
        }
        catch (ClassNotFoundException e) {
            System.err.println(this.getClass() + " could not resolve class " + this.className + ", from bundle " + this.bundleName);
            this.failed = true;
            return null;
        }
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        Class<?> clazz = this.resolveClass();
        return clazz != null && clazz.equals(contentType);
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        Class<?> clazz = this.resolveClass();
        return clazz != null && clazz.isInstance(content);
    }
}

