/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.sorters;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class SorterContribution
extends VisualsContribution {
    SorterRule modifierRule;

    public SorterContribution(NodeType nodeType, Test test, SorterRule modifierRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!modifierRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("Sorter rule is not compatible with the content type.");
        }
        this.modifierRule = modifierRule;
    }

    public Sorter getSorter(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.modifierRule.getSorter(graph, content);
            }
            return null;
        }
        catch (DatabaseException e) {
            return null;
        }
    }
}

