/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.sorters;

import java.util.Map;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.AbstractSorter;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.strings.AlphanumComparator;

public class AlphanumericSorter
extends AbstractSorter<String> {
    public static final AlphanumericSorter INSTANCE = new AlphanumericSorter();

    private AlphanumericSorter() {
    }

    @Override
    public String getSortingCriterion(ReadGraph graph, BrowseContext context, NodeContext node) throws DatabaseException {
        Map<String, String> labels = context.getLabel(graph, node);
        String label = labels.get("single");
        if (label == null) {
            return labels.values().iterator().next();
        }
        return label;
    }

    @Override
    public int compare(String a, String b) {
        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)a, (Object)b);
    }
}

