/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.sorters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public abstract class AbstractSorter<T>
implements Sorter {
    Comparator<OrderNodeContext<T>> comparator = new Comparator<OrderNodeContext<T>>(){

        @Override
        public int compare(OrderNodeContext<T> o1, OrderNodeContext<T> o2) {
            return AbstractSorter.this.compare(o1.criterion, o2.criterion);
        }
    };

    public abstract T getSortingCriterion(ReadGraph var1, BrowseContext var2, NodeContext var3) throws DatabaseException;

    public abstract int compare(T var1, T var2);

    @Override
    public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException {
        ArrayList<OrderNodeContext<T>> orderNodes = new ArrayList<OrderNodeContext<T>>(nodes.size());
        for (NodeContext nodeContext : nodes) {
            orderNodes.add(new OrderNodeContext<T>(nodeContext, this.getSortingCriterion(graph, context, nodeContext)));
        }
        Collections.sort(orderNodes, this.comparator);
        nodes.clear();
        for (OrderNodeContext orderNodeContext : orderNodes) {
            nodes.add(orderNodeContext.node);
        }
    }

    static class OrderNodeContext<T> {
        public final NodeContext node;
        public final T criterion;

        public OrderNodeContext(NodeContext node, T criterion) {
            this.node = node;
            this.criterion = criterion;
        }
    }
}

